﻿using UnityEngine;
using System.Collections;
using System.IO;

using MsgPack;

public class A
{
	public virtual void Read(AData data)
	{
		data.Print();
	}

	public virtual void Print()
	{
		Debug.LogError("Class A");
	}
}

public class B : A
{
	public override void Print()
	{
		Debug.LogError("Class B");
	}
}

public interface IData
{
	A CreateInstance();

	void Print();
}

public class AData : IData
{
	public int a;
	public int b;
	public string c;

	public virtual A CreateInstance()
	{
		return new A();
	}

	public virtual void Print()
	{
		Debug.LogError(string.Format("[Print From AData]{0}, {1}, {2}", a, b, c));
	}
}

public class BData :AData
{
	public int d;

	public override A CreateInstance()
	{
		return new B();
	}

	public override void Print()
	{
		Debug.LogError(string.Format("[Print From BData]{0}, {1}, {2}, {3}", a, b, c, d));
	}
}

public class Dat
{
	[MsgPack.Serialization.MessagePackRuntimeCollectionItemType]
	public IData[] arr = new IData[2];
	[MsgPack.Serialization.MessagePackRuntimeType]
	public AData a;

	public void Print()
	{
		for (int i = 0; i < arr.Length; i++) {
			arr[i].Print();
		}
		a.Print();
	}
}


public class Test : MonoBehaviour
{
	


	// Use this for initialization
	void Start()
	{
		Dat dat = new Dat();

		IData[] arr = new IData[2];
		arr[0] = new AData();
		((AData)arr[0]).a = 1;
		((AData)arr[0]).b = 2;
		((AData)arr[0]).c = "Oh yeah";

		arr[1] = new BData();
		((BData)arr[1]).a = 1;
		((BData)arr[1]).b = 2;
		((BData)arr[1]).c = "Oh yeah B";
		((BData)arr[1]).d = 4;

		dat.arr = arr;
		dat.a = new BData();
		dat.a.a = dat.a.b = ((BData)dat.a).d = 10;
		dat.a.c = "Tao la B ne";
		dat.Print();
		for (int i = 0; i < 2; i++) {
			dat.arr[i].Print();
		}
		MsgPack.Serialization.MessagePackSerializer.PrepareType<Dat>();
		var serializer = MsgPack.Serialization.SerializationContext.Default.GetSerializer<Dat>();



		string path = Application.persistentDataPath + "/Test.jbin";

		using (FileStream stream = File.Open(path, FileMode.Create)) {
			serializer.Pack(stream, dat);
			stream.Flush();
		}

		Debug.LogError("=====================");
		using (FileStream stream = File.Open(path, FileMode.Open)) {
			Dat a = serializer.Unpack(stream);
			a.Print();
			for (int i = 0; i < 2; i++) {
				a.arr[i].Print();
			}
		}
	}

	// Update is called once per frame
	void Update()
	{

	}
}
