package com.example.demo;

import java.time.Duration;
import java.util.Map;

import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.stereotype.Controller;

import lombok.extern.slf4j.Slf4j;
import reactor.core.publisher.Flux;

@Slf4j
@Controller
public class SocketController {

    @MessageMapping("test.requestStream")
    public Flux<DataBuffer> testRequestStream(DataBuffer data, @Headers Map<String, DataBuffer> headers) {
        log.info("-->> testRequestStream");
        log.info("payload: " + new String(data.asByteBuffer().array()));
        log.info("headers: " + headers);

        return Flux
            .interval(Duration.ofSeconds(3))
            .map(
                i -> new DefaultDataBufferFactory().wrap(("ID: " + i).getBytes())
            )
            ;
    }
    
}
