"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RSocketSample = void 0;
require("core-js");
var rsocket_core_1 = require("rsocket-core");
var rsocket_websocket_client_1 = __importDefault(require("rsocket-websocket-client"));
var RSocketSample = (function () {
    function RSocketSample() {
        console.log("RSocketSample");
        this.init();
    }
    RSocketSample.prototype.init = function () {
        var _this = this;
        RSocketSample.client
            .connect()
            .then(function (socket) {
            socket.connectionStatus()
                .subscribe(function (event) {
                console.log("connection status event: ", event);
            });
            _this.socket = socket;
            _this.requestStream();
        }, function (error) {
            console.log('error:', error);
        });
    };
    RSocketSample.prototype.requestStream = function () {
        console.log("requestStream");
        this.socket
            .requestStream({
            data: Buffer.from('request-stream'),
            metadata: rsocket_core_1.encodeCompositeMetadata([
                [rsocket_core_1.TEXT_PLAIN, Buffer.from('Hello World')],
                [rsocket_core_1.MESSAGE_RSOCKET_ROUTING, rsocket_core_1.encodeRoute("test.requestStream")],
                [
                    rsocket_core_1.MESSAGE_RSOCKET_AUTHENTICATION,
                    rsocket_core_1.encodeSimpleAuthMetadata('user', 'pass'),
                ],
                ['custom/test/metadata', Buffer.from([1, 2, 3])],
            ]),
        })
            .subscribe({
            onComplete: function () { return console.log('Request-stream completed'); },
            onError: function (error) { return console.error("Request-stream error:" + error.message); },
            onNext: function (value) { return console.log('got message', new TextDecoder("utf-8").decode(value.data), value.metadata); },
            onSubscribe: function (sub) { return sub.request(999); },
        });
    };
    RSocketSample.maxRSocketRequestN = 2147483647;
    RSocketSample.clientConfig = {
        setup: {
            dataMimeType: rsocket_core_1.APPLICATION_OCTET_STREAM.string,
            keepAlive: 60000,
            lifetime: 180000,
            metadataMimeType: rsocket_core_1.MESSAGE_RSOCKET_COMPOSITE_METADATA.string,
        },
        transport: new rsocket_websocket_client_1.default({
            debug: true,
            url: 'ws://localhost:5556/ws',
        }, rsocket_core_1.BufferEncoders),
    };
    RSocketSample.client = new rsocket_core_1.RSocketClient(RSocketSample.clientConfig);
    return RSocketSample;
}());
exports.RSocketSample = RSocketSample;
new RSocketSample();
//# sourceMappingURL=index.js.map