import 'core-js';

import {
    RSocketClient,
    ClientConfig,
    BufferEncoders,
    encodeCompositeMetadata,
    TEXT_PLAIN,
    APPLICATION_OCTET_STREAM,
    MESSAGE_RSOCKET_COMPOSITE_METADATA,
    MESSAGE_RSOCKET_ROUTING,
    MESSAGE_RSOCKET_AUTHENTICATION,
    encodeRoute,
    encodeSimpleAuthMetadata,
    IdentitySerializer,
  } from 'rsocket-core';
  import RSocketWebSocketClient from 'rsocket-websocket-client';
  import { DuplexConnection, Payload, ReactiveSocket, Responder } from 'rsocket-types';

export class RSocketSample{

    private static maxRSocketRequestN: number = 2147483647;

    private static clientConfig: ClientConfig<Buffer, Buffer> = {
        setup: {
            dataMimeType: APPLICATION_OCTET_STREAM.string,
            keepAlive: 60000,
            lifetime: 180000,
            metadataMimeType: MESSAGE_RSOCKET_COMPOSITE_METADATA.string,
        },
        transport:  new RSocketWebSocketClient(
            {
                debug: true,
                url: 'ws://localhost:5556/ws',
            },
            BufferEncoders,
        ),
        
    };


    private static client: RSocketClient<Buffer, Buffer> = new RSocketClient<Buffer, Buffer>(
        RSocketSample.clientConfig
    );



    private socket: ReactiveSocket<Buffer, Buffer>;



    constructor(){
        console.log("RSocketSample");

        this.init();
    }


    private init() {
        RSocketSample.client
            .connect()
            .then(
                socket => {
                    socket.connectionStatus()
                        .subscribe(
                            event => {
                                console.log("connection status event: ", event);
                            });
                        
                    this.socket = socket;
                    this.requestStream();
                },
                error => {
                    console.log('error:', error);
                }
            )
            ;
    }



    private requestStream(){
        console.log("requestStream");

        this.socket
            .requestStream({
                data: Buffer.from('request-stream'),
                metadata: encodeCompositeMetadata(
                    [
                        [TEXT_PLAIN, Buffer.from('Hello World')],
                        [MESSAGE_RSOCKET_ROUTING, encodeRoute("test.requestStream")],
                        [
                            MESSAGE_RSOCKET_AUTHENTICATION,
                            encodeSimpleAuthMetadata('user', 'pass'),
                        ],
                        ['custom/test/metadata', Buffer.from([1, 2, 3])],
                    ]
                ),
            })
            .subscribe({
                onComplete: () => console.log('Request-stream completed'),
                onError: error => console.error(`Request-stream error:${error.message}`),
                onNext: value => console.log('got message', new TextDecoder("utf-8").decode(value.data), value.metadata),
                onSubscribe: sub => sub.request(999),
            });

    }


}


new RSocketSample();