const path = require('path');
var webpack = require('webpack');
const CopyPlugin = require('copy-webpack-plugin');

module.exports = {
    mode: 'development',
    entry: './build/index.js',
    output: {
        filename: 'index.min.js',
        path: path.resolve(__dirname, 'pack'),
    },
    optimization: {
        usedExports: true,
    },
    devtool: 'inline-source-map',
    plugins: [
        new CopyPlugin([
            { from: 'src', to: '', ignore: ['*.ts'], flatten: false},
        ]),
    ],
    resolve: {
        modules: [
            'node_modules',
        ]
    },
    module: {
        rules: [
            {
                test: /\.m?js$/,
                exclude: /(node_modules|bower_components)/,
                use: {
                    loader: 'babel-loader',
                    options: {
                        presets: ['@babel/preset-env'],
                        plugins: [
                            '@babel/plugin-transform-runtime'
                        ],
                        sourceType: "script",
                    }
                }
            }
        ]
    },
    devServer: {
        contentBase: path.join(__dirname, 'pack'),
        compress: true,
        host: process.env.HOST || '0.0.0.0',
        port: 5555,
        hot: true
    },
};