package com.example.demo;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.DriverManager;

import static org.springframework.web.servlet.function.ServerResponse.ok;

@SpringBootApplication
public class DemoApplication {

	public static void main(String[] args) {
		SpringApplication.run(DemoApplication.class, args);
	}

	@Bean
	DataSource ds(){

		HikariDataSource dataSource = new HikariDataSource();
		dataSource.setJdbcUrl("jdbc:h2:mem:demo");
		return dataSource;
	}

	@Bean
	RouterFunction routerFunction(DataSource ds){
		return RouterFunctions.route().GET("/hikari", req -> {
			try(Connection conn = ds.getConnection()) {
				return ok().body("connection opened");
			}
		}).build();
	}

	@Bean
	RouterFunction routerFunction2(){
		return RouterFunctions.route().GET("/direct", req -> {
			Class.forName ("org.h2.Driver");
			try(Connection conn = DriverManager.getConnection ("jdbc:h2:mem:demo")) {
				return ok().body("connection opened");
			}
		}).build();
	}
}
