package com.example.persistence;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

import java.time.Instant;

@Embeddable
@Getter
@Setter
public class Audit {
    @CreatedDate
    @Column(name = "created", nullable = false)
    public Instant created;

    @LastModifiedDate
    @Column(name = "modified")
    public Instant modified;
}
