package com.example.persistence.sentmessage;

import jakarta.persistence.*;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

@Entity
@Table(name = "sent_attachment")
@Getter
@Setter
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
class SentAttachmentEntity {
    @Id
    @GeneratedValue
    @EqualsAndHashCode.Include
    @Column(name = "id")
    private Long id;

    @Column(name = "filename", nullable = false, length = 254)
    private String filename;

    @Column(name = "mime_type", nullable = false, length = 64)
    private String mimeType;

    @Column(name = "size", nullable = false)
    private long size;
}
