package com.example.persistence.sentmessage;

import com.example.persistence.Audit;
import jakarta.persistence.*;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import java.time.Instant;
import java.util.Collection;

@Entity
@Table(
        name = "sent_message",
        uniqueConstraints = @UniqueConstraint(name = "uc_sent_message_handle", columnNames = "handle")
)
@Getter
@Setter
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
@EntityListeners(AuditingEntityListener.class)
class SentMessageEntity {
    @Id
    @GeneratedValue
    @EqualsAndHashCode.Include
    @Column(name = "id")
    private Long id;

    @Embedded
    private Audit audit = new Audit();

    @Column(name = "handle", length = 12, nullable = false)
    private String handle;

    @Column(name = "timestamp", nullable = false)
    private Instant timestamp;

    @Column(name = "category", length = 64)
    private String category;

    @Column(name = "subject", nullable = false, length = 254)
    private String subject;

    @Column(name = "body", nullable = false, length = 500_000)
    private String body;

    @Column(name = "from_bpid", length = 10, nullable = false)
    private String fromBpid;

    @OneToMany(
            cascade = CascadeType.ALL,
            fetch = FetchType.EAGER,
            orphanRemoval = true
    )
    @JoinColumn(
            name = "sent_message_id",
            foreignKey = @ForeignKey(name = "fk_sent_message_attachment")
    )
    private Collection<SentAttachmentEntity> attachments;
}
