package org.springframework.boot.showcase;

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.net.URL;

import org.junit.jupiter.api.Test;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;

class VaultConfigurationPropertiesConfigurationTest {

	@Test
	public void testReadProperties() throws Exception{
		try (AnnotationConfigApplicationContext annotationConfigApplicationContext = new AnnotationConfigApplicationContext(TestConfig.class)) {
			final TestProperties testProperties = annotationConfigApplicationContext.getBean(TestProperties.class);
			assertEquals("TestPassword", testProperties.getSecret());
			assertEquals(new URL("https://www.mycompany.de"), testProperties.getUrl());
		}
	}

	@Configuration
	@EnableVaultConfigurationProperties
	@PropertySource(value = "classpath:/testproperties.properties")
	static class TestConfig {

		@Bean
		@ConfigurationProperties(prefix = "testproperties")
		public TestProperties testProperties() {
			return new TestProperties();
		}

		@Bean
		@Primary
		public IVault vault() {
			return ((safe, aimUser, objectName, name) -> {
				final String result;
				assertEquals("MySafe", safe);
				assertEquals("IBBR", aimUser);
				assertEquals("TEST_OBJECT", objectName);
				if ("Content".equals(name)) {
					result = "TestPassword";
				} else if ("Url".equals(name)) {
					result = "https://www.mycompany.de";
				} else {
					result = null;
				}
				return result;
			});
		}
	}

	public static class TestProperties {
		private String secret;
		private URL url;

		public String getSecret() {
			return secret;
		}

		public void setSecret(String secret) {
			this.secret = secret;
		}

		public URL getUrl() {
			return url;
		}

		public void setUrl(URL url) {
			this.url = url;
		}
	}
}