#!/bin/bash

base_dir=$(cd `dirname $0`/..; pwd)
class_path="$CLASSPATH"

for file in "$base_dir"/libs/*.jar;
do
	class_path="$class_path":"$file"
done

java -Dfile.encoding=UTF-8 -Dspring.config.location="$base_dir"/resources/application.yml  -Dlog.home="$base_dir"/logs -Dlogback.configurationFile="$base_dir"/resources/logback.xml  -cp $class_path com.example.demo.ServerApplication "$@"