package com.example.demo;

import com.example.demo.classloader.XBootClassLoader;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class Main {
    public static void main(String[] args) throws Exception {

        ClassLoader classLoader = Main.class.getClassLoader();

        String classpath = Main.class.getResource("/").getPath();

        System.out.println(classpath);


        File file = new File(classpath + "../springboot-demo_1.0.0-package/springboot-demo_1.0.0/libs");
        File[] files = file.listFiles();

        List<URL> urls = new ArrayList<>();
        for (File f : files) {
           urls.add(f.getAbsoluteFile().toURI().toURL());
        }

        System.out.println(urls);

        XBootClassLoader xJarClassLoader = new XBootClassLoader(urls.toArray(new URL[0]), classLoader.getParent());
        Thread.currentThread().setContextClassLoader(xJarClassLoader);
        Class<?> mainClass = xJarClassLoader.loadClass(ServerApplication.class.getName());
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{args});

    }
}
