package com.example.demo.classloader.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class XReflection {

    public static XField field(Class<?> claxx, String name) throws NoSuchFieldException {
        if (claxx == null) throw new NullPointerException();
        if (name == null) throw new IllegalArgumentException("field name == null");
        while (claxx != null) {
            try {
                Field field = claxx.getDeclaredField(name);
                field.setAccessible(true);
                return new XField(field);
            } catch (NoSuchFieldException e) {
                claxx = claxx.getSuperclass();
            }
        }
        throw new NoSuchFieldException(name);
    }

    public static XMethod method(Class<?> claxx, String name, Class<?>... parameterTypes) throws NoSuchMethodException {
        if (claxx == null) throw new NullPointerException();
        if (name == null) throw new IllegalArgumentException("method name == null");
        while (claxx != null) {
            try {
                Method method = claxx.getDeclaredMethod(name, parameterTypes);
                method.setAccessible(true);
                return new XMethod(method);
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
                claxx = claxx.getSuperclass();
            }
        }
        throw new NoSuchMethodException(name);
    }

}
