import org.jetbrains.kotlin.gradle.tasks.KotlinCompile

plugins {
	id("org.springframework.boot") version "3.2.2"
	id("io.spring.dependency-management") version "1.1.4"
	kotlin("jvm") version "1.9.22"
	kotlin("plugin.spring") version "1.9.22"
}

group = "io.github.antechrestos.springboot"
version = "0.0.1-SNAPSHOT"

java {
	sourceCompatibility = JavaVersion.VERSION_17
}

repositories {
	mavenCentral()
}

dependencies {
	implementation("org.springframework.boot:spring-boot-starter-webflux")
	implementation("com.fasterxml.jackson.module:jackson-module-kotlin")
	implementation("io.projectreactor.kotlin:reactor-kotlin-extensions")
	implementation("org.jetbrains.kotlin:kotlin-reflect")
	implementation("org.jetbrains.kotlinx:kotlinx-coroutines-reactor")
	testImplementation("org.springframework.boot:spring-boot-starter-test")
	testImplementation("io.projectreactor:reactor-test")
}

tasks.withType<KotlinCompile> {
	kotlinOptions {
		freeCompilerArgs += "-Xjsr305=strict"
		jvmTarget = "17"
	}
}

tasks.withType<Test> {
	useJUnitPlatform()
}


tasks.bootBuildImage {
    buildpacks = listOf(
        // these five next build packs plus spring-boot are the one by default when none is specified
        "gcr.io/paketo-buildpacks/ca-certificates:3.6.7",
        "gcr.io/paketo-buildpacks/bellsoft-liberica:10.4.4",
        "gcr.io/paketo-buildpacks/syft:1.42.0",
        "gcr.io/paketo-buildpacks/executable-jar:6.8.3",
        "gcr.io/paketo-buildpacks/dist-zip:5.6.8",
        // adding new-relic build pack to get the newrelic java-agent
        "gcr.io/paketo-buildpacks/new-relic:8.7.0",
        // put spring-boot last as order matters
        "gcr.io/paketo-buildpacks/spring-boot:5.27.8",
    )
    bindings = listOf("$projectDir/src/main/buildpack/new-relic:/platform/bindings/new-relic:ro")
}

