package com.example.TestRestAPI.controller;

import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/v1/sayHello")
public class RESTApiController {
    private static final String CONTENT_TYPE_APPLICATION_ZIP = "application/zip";
    @GetMapping(produces = { MediaType.TEXT_PLAIN_VALUE, CONTENT_TYPE_APPLICATION_ZIP })
    public String sayHello1(@RequestHeader("Accept") List<String> acceptHeader) throws MyException {
        List<String> acceptTypes = new ArrayList<>(acceptHeader);
        // remove all acceptable types from the list
        acceptTypes.remove(CONTENT_TYPE_APPLICATION_ZIP);
        acceptTypes.remove(MediaType.TEXT_PLAIN_VALUE);
        acceptTypes.remove(MediaType.APPLICATION_JSON_VALUE);
        // anything left is unacceptable
        if (!acceptTypes.isEmpty()) {
            throw new MyException("Error in content-type");
        }
        return "{'greeting':'Hello!'}";
    }
}
