package com.example.TestRestAPI.controller;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.io.Resource;
import org.springframework.http.*;

import java.util.Arrays;

import static org.assertj.core.api.Assertions.assertThat;

@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
public class RESTApiControllerTest {

    @Autowired
    TestRestTemplate testRestTemplate;


    @Test
    public void testInvalidAcceptHeadersWithoutJsonType(){
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.parseMediaType("application/zip"), MediaType.TEXT_PLAIN, MediaType.APPLICATION_OCTET_STREAM));
        HttpEntity<String> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<?> responseEntity = testRestTemplate.withBasicAuth("user","password")
                .exchange("/api/v1/sayHello", HttpMethod.GET,  httpEntity, Resource.class);
        assertThat(responseEntity.getStatusCode()).isEqualTo(HttpStatus.NOT_ACCEPTABLE);
    }

    @Test
    public void testInvalidAcceptHeadersWithJsonType(){
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.parseMediaType("application/zip"), MediaType.TEXT_PLAIN, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_JSON));
        HttpEntity<String> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<?> responseEntity = testRestTemplate.withBasicAuth("user","password")
                .exchange("/api/v1/sayHello", HttpMethod.GET,  httpEntity, Resource.class);
        assertThat(responseEntity.getStatusCode()).isEqualTo(HttpStatus.NOT_ACCEPTABLE);
    }
}
