package org.example;

import static io.restassured.RestAssured.when;
import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.not;

import org.junit.jupiter.api.Test;
import org.springframework.boot.actuate.autoconfigure.web.server.LocalManagementPort;
import org.springframework.boot.test.autoconfigure.actuate.metrics.AutoConfigureMetrics;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTest.WebEnvironment;
import org.springframework.boot.web.server.LocalServerPort;

@AutoConfigureMetrics
@SpringBootTest(webEnvironment = WebEnvironment.RANDOM_PORT)
public class AppTest {

  @LocalServerPort
  int servicePort;
  @LocalManagementPort
  int managementPort;

  @Test
  void shouldNotHaveHealthEndpointInPrometheusMetrics() {
    when()
        .get("http://localhost:" + managementPort + "/health")
        .then()
        .statusCode(200);
    when()
        .get("http://localhost:" + servicePort + "/ping")
        .then()
        .statusCode(200);

    when()
        .get("http://localhost:" + managementPort + "/prometheus")
        .then()
        .statusCode(200)
        .body(containsString(
            "http_server_requests_seconds_count{exception=\"None\",method=\"GET\",outcome=\"SUCCESS\",status=\"200\",uri=\"/ping\",}"))
        .body(not(containsString(
            "http_server_requests_seconds_count{exception=\"None\",method=\"GET\",outcome=\"SUCCESS\",status=\"200\",uri=\"/health\",}")));
  }

}
