package org.gradle.accessors.dm;

import org.gradle.api.NonNullApi;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.plugin.use.PluginDependency;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.internal.catalog.AbstractExternalDependencyFactory;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import java.util.Map;
import javax.inject.Inject;

/**
 * A catalog of dependencies accessible via the `libs` extension.
*/
@NonNullApi
public class LibrariesForLibs extends AbstractExternalDependencyFactory {

    private final AbstractExternalDependencyFactory owner = this;
    private final ApiLibraryAccessors laccForApiLibraryAccessors = new ApiLibraryAccessors(owner);
    private final ChassisLibraryAccessors laccForChassisLibraryAccessors = new ChassisLibraryAccessors(owner);
    private final CommonsLibraryAccessors laccForCommonsLibraryAccessors = new CommonsLibraryAccessors(owner);
    private final DgsLibraryAccessors laccForDgsLibraryAccessors = new DgsLibraryAccessors(owner);
    private final GraphqlLibraryAccessors laccForGraphqlLibraryAccessors = new GraphqlLibraryAccessors(owner);
    private final ImmutablesLibraryAccessors laccForImmutablesLibraryAccessors = new ImmutablesLibraryAccessors(owner);
    private final JacksonLibraryAccessors laccForJacksonLibraryAccessors = new JacksonLibraryAccessors(owner);
    private final JakartaLibraryAccessors laccForJakartaLibraryAccessors = new JakartaLibraryAccessors(owner);
    private final JaxrsLibraryAccessors laccForJaxrsLibraryAccessors = new JaxrsLibraryAccessors(owner);
    private final JunitLibraryAccessors laccForJunitLibraryAccessors = new JunitLibraryAccessors(owner);
    private final KotlinLibraryAccessors laccForKotlinLibraryAccessors = new KotlinLibraryAccessors(owner);
    private final LiquibaseLibraryAccessors laccForLiquibaseLibraryAccessors = new LiquibaseLibraryAccessors(owner);
    private final Log4jLibraryAccessors laccForLog4jLibraryAccessors = new Log4jLibraryAccessors(owner);
    private final Slf4jLibraryAccessors laccForSlf4jLibraryAccessors = new Slf4jLibraryAccessors(owner);
    private final SpringLibraryAccessors laccForSpringLibraryAccessors = new SpringLibraryAccessors(owner);
    private final VersionAccessors vaccForVersionAccessors = new VersionAccessors(providers, config);
    private final BundleAccessors baccForBundleAccessors = new BundleAccessors(providers, config);
    private final PluginAccessors paccForPluginAccessors = new PluginAccessors(providers, config);

    @Inject
    public LibrariesForLibs(DefaultVersionCatalog config, ProviderFactory providers) {
        super(config, providers);
    }

        /**
         * Creates a dependency provider for assertj (org.assertj:assertj-core)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getAssertj() { return create("assertj"); }

        /**
         * Creates a dependency provider for bndlib (biz.aQute.bnd:bndlib)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getBndlib() { return create("bndlib"); }

        /**
         * Creates a dependency provider for equalsverifier (nl.jqno.equalsverifier:equalsverifier)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getEqualsverifier() { return create("equalsverifier"); }

        /**
         * Creates a dependency provider for h2 (com.h2database:h2)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getH2() { return create("h2"); }

        /**
         * Creates a dependency provider for jaxb (javax.xml.bind:jaxb-api)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getJaxb() { return create("jaxb"); }

        /**
         * Creates a dependency provider for jpa (jakarta.persistence:jakarta.persistence-api)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getJpa() { return create("jpa"); }

        /**
         * Creates a dependency provider for mockito (org.mockito:mockito-core)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getMockito() { return create("mockito"); }

        /**
         * Creates a dependency provider for postgres (org.postgresql:postgresql)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getPostgres() { return create("postgres"); }

        /**
         * Creates a dependency provider for tika (org.apache.tika:tika-core)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTika() { return create("tika"); }

        /**
         * Creates a dependency provider for uuid (com.github.f4b6a3:uuid-creator)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getUuid() { return create("uuid"); }

        /**
         * Creates a dependency provider for validation (jakarta.validation:jakarta.validation-api)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getValidation() { return create("validation"); }

        /**
         * Creates a dependency provider for vavr (io.vavr:vavr)
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getVavr() { return create("vavr"); }

    /**
     * Returns the group of libraries at api
     */
    public ApiLibraryAccessors getApi() { return laccForApiLibraryAccessors; }

    /**
     * Returns the group of libraries at chassis
     */
    public ChassisLibraryAccessors getChassis() { return laccForChassisLibraryAccessors; }

    /**
     * Returns the group of libraries at commons
     */
    public CommonsLibraryAccessors getCommons() { return laccForCommonsLibraryAccessors; }

    /**
     * Returns the group of libraries at dgs
     */
    public DgsLibraryAccessors getDgs() { return laccForDgsLibraryAccessors; }

    /**
     * Returns the group of libraries at graphql
     */
    public GraphqlLibraryAccessors getGraphql() { return laccForGraphqlLibraryAccessors; }

    /**
     * Returns the group of libraries at immutables
     */
    public ImmutablesLibraryAccessors getImmutables() { return laccForImmutablesLibraryAccessors; }

    /**
     * Returns the group of libraries at jackson
     */
    public JacksonLibraryAccessors getJackson() { return laccForJacksonLibraryAccessors; }

    /**
     * Returns the group of libraries at jakarta
     */
    public JakartaLibraryAccessors getJakarta() { return laccForJakartaLibraryAccessors; }

    /**
     * Returns the group of libraries at jaxrs
     */
    public JaxrsLibraryAccessors getJaxrs() { return laccForJaxrsLibraryAccessors; }

    /**
     * Returns the group of libraries at junit
     */
    public JunitLibraryAccessors getJunit() { return laccForJunitLibraryAccessors; }

    /**
     * Returns the group of libraries at kotlin
     */
    public KotlinLibraryAccessors getKotlin() { return laccForKotlinLibraryAccessors; }

    /**
     * Returns the group of libraries at liquibase
     */
    public LiquibaseLibraryAccessors getLiquibase() { return laccForLiquibaseLibraryAccessors; }

    /**
     * Returns the group of libraries at log4j
     */
    public Log4jLibraryAccessors getLog4j() { return laccForLog4jLibraryAccessors; }

    /**
     * Returns the group of libraries at slf4j
     */
    public Slf4jLibraryAccessors getSlf4j() { return laccForSlf4jLibraryAccessors; }

    /**
     * Returns the group of libraries at spring
     */
    public SpringLibraryAccessors getSpring() { return laccForSpringLibraryAccessors; }

    /**
     * Returns the group of versions at versions
     */
    public VersionAccessors getVersions() { return vaccForVersionAccessors; }

    /**
     * Returns the group of bundles at bundles
     */
    public BundleAccessors getBundles() { return baccForBundleAccessors; }

    /**
     * Returns the group of plugins at plugins
     */
    public PluginAccessors getPlugins() { return paccForPluginAccessors; }

    public static class ApiLibraryAccessors extends SubDependencyFactory {

        public ApiLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for guardian (org.apiguardian:apiguardian-api)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getGuardian() { return create("api.guardian"); }

    }

    public static class ChassisLibraryAccessors extends SubDependencyFactory {
        private final ChassisStarterLibraryAccessors laccForChassisStarterLibraryAccessors = new ChassisStarterLibraryAccessors(owner);

        public ChassisLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for bom (com.capitalone.chassis.engine.starters:chassis-spring-boot-starters-bom)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getBom() { return create("chassis.bom"); }

        /**
         * Returns the group of libraries at chassis.starter
         */
        public ChassisStarterLibraryAccessors getStarter() { return laccForChassisStarterLibraryAccessors; }

    }

    public static class ChassisStarterLibraryAccessors extends SubDependencyFactory {

        public ChassisStarterLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for jersey (com.capitalone.chassis.engine.starters:chassis-spring-boot-starter-jersey-rest)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getJersey() { return create("chassis.starter.jersey"); }

    }

    public static class CommonsLibraryAccessors extends SubDependencyFactory {

        public CommonsLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for io (commons-io:commons-io)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getIo() { return create("commons.io"); }

            /**
             * Creates a dependency provider for lang (org.apache.commons:commons-lang3)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getLang() { return create("commons.lang"); }

    }

    public static class DgsLibraryAccessors extends SubDependencyFactory {

        public DgsLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for graphql (com.netflix.graphql.dgs:graphql-dgs)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getGraphql() { return create("dgs.graphql"); }

            /**
             * Creates a dependency provider for paging (com.netflix.graphql.dgs:graphql-dgs-pagination)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getPaging() { return create("dgs.paging"); }

            /**
             * Creates a dependency provider for platform (com.netflix.graphql.dgs:graphql-dgs-platform-dependencies)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getPlatform() { return create("dgs.platform"); }

            /**
             * Creates a dependency provider for starter (com.netflix.graphql.dgs:graphql-dgs-spring-boot-starter)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getStarter() { return create("dgs.starter"); }

    }

    public static class GraphqlLibraryAccessors extends SubDependencyFactory {

        public GraphqlLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for java (com.graphql-java:graphql-java)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getJava() { return create("graphql.java"); }

    }

    public static class ImmutablesLibraryAccessors extends SubDependencyFactory {

        public ImmutablesLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for annotations (org.immutables:value-annotations)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getAnnotations() { return create("immutables.annotations"); }

            /**
             * Creates a dependency provider for core (org.immutables:value)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getCore() { return create("immutables.core"); }

    }

    public static class JacksonLibraryAccessors extends SubDependencyFactory {
        private final JacksonDataformatLibraryAccessors laccForJacksonDataformatLibraryAccessors = new JacksonDataformatLibraryAccessors(owner);
        private final JacksonModuleLibraryAccessors laccForJacksonModuleLibraryAccessors = new JacksonModuleLibraryAccessors(owner);

        public JacksonLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for annotations (com.fasterxml.jackson.core:jackson-annotations)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getAnnotations() { return create("jackson.annotations"); }

            /**
             * Creates a dependency provider for core (com.fasterxml.jackson.core:jackson-core)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getCore() { return create("jackson.core"); }

            /**
             * Creates a dependency provider for databind (com.fasterxml.jackson.core:jackson-databind)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getDatabind() { return create("jackson.databind"); }

        /**
         * Returns the group of libraries at jackson.dataformat
         */
        public JacksonDataformatLibraryAccessors getDataformat() { return laccForJacksonDataformatLibraryAccessors; }

        /**
         * Returns the group of libraries at jackson.module
         */
        public JacksonModuleLibraryAccessors getModule() { return laccForJacksonModuleLibraryAccessors; }

    }

    public static class JacksonDataformatLibraryAccessors extends SubDependencyFactory {

        public JacksonDataformatLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for yaml (com.fasterxml.jackson.dataformat:jackson-dataformat-yaml)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getYaml() { return create("jackson.dataformat.yaml"); }

    }

    public static class JacksonModuleLibraryAccessors extends SubDependencyFactory {
        private final JacksonModuleParameterLibraryAccessors laccForJacksonModuleParameterLibraryAccessors = new JacksonModuleParameterLibraryAccessors(owner);

        public JacksonModuleLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Returns the group of libraries at jackson.module.parameter
         */
        public JacksonModuleParameterLibraryAccessors getParameter() { return laccForJacksonModuleParameterLibraryAccessors; }

    }

    public static class JacksonModuleParameterLibraryAccessors extends SubDependencyFactory {

        public JacksonModuleParameterLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for names (com.fasterxml.jackson.module:jackson-module-parameter-names)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getNames() { return create("jackson.module.parameter.names"); }

    }

    public static class JakartaLibraryAccessors extends SubDependencyFactory {

        public JakartaLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for annotation (jakarta.annotation:jakarta.annotation-api)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getAnnotation() { return create("jakarta.annotation"); }

    }

    public static class JaxrsLibraryAccessors extends SubDependencyFactory {

        public JaxrsLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for api (jakarta.ws.rs:jakarta.ws.rs-api)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getApi() { return create("jaxrs.api"); }

    }

    public static class JunitLibraryAccessors extends SubDependencyFactory {

        public JunitLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for api (org.junit.jupiter:junit-jupiter-api)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getApi() { return create("junit.api"); }

            /**
             * Creates a dependency provider for engine (org.junit.jupiter:junit-jupiter-engine)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getEngine() { return create("junit.engine"); }

            /**
             * Creates a dependency provider for jupiter (org.junit.jupiter:junit-jupiter)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getJupiter() { return create("junit.jupiter"); }

            /**
             * Creates a dependency provider for parameters (org.junit.jupiter:junit-jupiter-params)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getParameters() { return create("junit.parameters"); }

    }

    public static class KotlinLibraryAccessors extends SubDependencyFactory {

        public KotlinLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for reflect (org.jetbrains.kotlin:kotlin-reflect)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getReflect() { return create("kotlin.reflect"); }

    }

    public static class LiquibaseLibraryAccessors extends SubDependencyFactory {

        public LiquibaseLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for core (org.liquibase:liquibase-core)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getCore() { return create("liquibase.core"); }

    }

    public static class Log4jLibraryAccessors extends SubDependencyFactory {

        public Log4jLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for api (org.apache.logging.log4j:log4j-api)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getApi() { return create("log4j.api"); }

    }

    public static class Slf4jLibraryAccessors extends SubDependencyFactory {

        public Slf4jLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for nop (org.slf4j:slf4j-nop)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getNop() { return create("slf4j.nop"); }

    }

    public static class SpringLibraryAccessors extends SubDependencyFactory {
        private final SpringBootLibraryAccessors laccForSpringBootLibraryAccessors = new SpringBootLibraryAccessors(owner);
        private final SpringCloudLibraryAccessors laccForSpringCloudLibraryAccessors = new SpringCloudLibraryAccessors(owner);
        private final SpringDataLibraryAccessors laccForSpringDataLibraryAccessors = new SpringDataLibraryAccessors(owner);
        private final SpringSecurityLibraryAccessors laccForSpringSecurityLibraryAccessors = new SpringSecurityLibraryAccessors(owner);

        public SpringLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for beans (org.springframework:spring-beans)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getBeans() { return create("spring.beans"); }

            /**
             * Creates a dependency provider for context (org.springframework:spring-context)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getContext() { return create("spring.context"); }

            /**
             * Creates a dependency provider for core (org.springframework:spring-core)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getCore() { return create("spring.core"); }

            /**
             * Creates a dependency provider for platform (org.springframework.boot:spring-boot-starter-parent)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getPlatform() { return create("spring.platform"); }

            /**
             * Creates a dependency provider for test (org.springframework:spring-test)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getTest() { return create("spring.test"); }

            /**
             * Creates a dependency provider for tx (org.springframework:spring-tx)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getTx() { return create("spring.tx"); }

        /**
         * Returns the group of libraries at spring.boot
         */
        public SpringBootLibraryAccessors getBoot() { return laccForSpringBootLibraryAccessors; }

        /**
         * Returns the group of libraries at spring.cloud
         */
        public SpringCloudLibraryAccessors getCloud() { return laccForSpringCloudLibraryAccessors; }

        /**
         * Returns the group of libraries at spring.data
         */
        public SpringDataLibraryAccessors getData() { return laccForSpringDataLibraryAccessors; }

        /**
         * Returns the group of libraries at spring.security
         */
        public SpringSecurityLibraryAccessors getSecurity() { return laccForSpringSecurityLibraryAccessors; }

    }

    public static class SpringBootLibraryAccessors extends SubDependencyFactory {
        private final SpringBootStarterLibraryAccessors laccForSpringBootStarterLibraryAccessors = new SpringBootStarterLibraryAccessors(owner);
        private final SpringBootTestLibraryAccessors laccForSpringBootTestLibraryAccessors = new SpringBootTestLibraryAccessors(owner);

        public SpringBootLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for autoconfigure (org.springframework.boot:spring-boot-autoconfigure)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getAutoconfigure() { return create("spring.boot.autoconfigure"); }

            /**
             * Creates a dependency provider for devtools (org.springframework.boot:spring-boot-devtools)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getDevtools() { return create("spring.boot.devtools"); }

        /**
         * Returns the group of libraries at spring.boot.starter
         */
        public SpringBootStarterLibraryAccessors getStarter() { return laccForSpringBootStarterLibraryAccessors; }

        /**
         * Returns the group of libraries at spring.boot.test
         */
        public SpringBootTestLibraryAccessors getTest() { return laccForSpringBootTestLibraryAccessors; }

    }

    public static class SpringBootStarterLibraryAccessors extends SubDependencyFactory {
        private final SpringBootStarterOauth2LibraryAccessors laccForSpringBootStarterOauth2LibraryAccessors = new SpringBootStarterOauth2LibraryAccessors(owner);

        public SpringBootStarterLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for actuator (org.springframework.boot:spring-boot-starter-actuator)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getActuator() { return create("spring.boot.starter.actuator"); }

            /**
             * Creates a dependency provider for core (org.springframework.boot:spring-boot-starter)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getCore() { return create("spring.boot.starter.core"); }

            /**
             * Creates a dependency provider for jackson (org.springframework.boot:spring-boot-starter-jackson)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getJackson() { return create("spring.boot.starter.jackson"); }

            /**
             * Creates a dependency provider for jpa (org.springframework.boot:spring-boot-starter-data-jpa)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getJpa() { return create("spring.boot.starter.jpa"); }

            /**
             * Creates a dependency provider for log4j2 (org.springframework.boot:spring-boot-starter-log4j2)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getLog4j2() { return create("spring.boot.starter.log4j2"); }

            /**
             * Creates a dependency provider for security (org.springframework.boot:spring-boot-starter-security)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getSecurity() { return create("spring.boot.starter.security"); }

            /**
             * Creates a dependency provider for web (org.springframework.boot:spring-boot-starter-web)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getWeb() { return create("spring.boot.starter.web"); }

            /**
             * Creates a dependency provider for webflux (org.springframework.boot:spring-boot-starter-webflux)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getWebflux() { return create("spring.boot.starter.webflux"); }

        /**
         * Returns the group of libraries at spring.boot.starter.oauth2
         */
        public SpringBootStarterOauth2LibraryAccessors getOauth2() { return laccForSpringBootStarterOauth2LibraryAccessors; }

    }

    public static class SpringBootStarterOauth2LibraryAccessors extends SubDependencyFactory {

        public SpringBootStarterOauth2LibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for client (org.springframework.boot:spring-boot-starter-oauth2-client)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getClient() { return create("spring.boot.starter.oauth2.client"); }

    }

    public static class SpringBootTestLibraryAccessors extends SubDependencyFactory {

        public SpringBootTestLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for autoconfigure (org.springframework.boot:spring-boot-test-autoconfigure)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getAutoconfigure() { return create("spring.boot.test.autoconfigure"); }

            /**
             * Creates a dependency provider for core (org.springframework.boot:spring-boot-test)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getCore() { return create("spring.boot.test.core"); }

    }

    public static class SpringCloudLibraryAccessors extends SubDependencyFactory {
        private final SpringCloudStarterLibraryAccessors laccForSpringCloudStarterLibraryAccessors = new SpringCloudStarterLibraryAccessors(owner);

        public SpringCloudLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for dependencies (org.springframework.cloud:spring-cloud-dependencies)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getDependencies() { return create("spring.cloud.dependencies"); }

            /**
             * Creates a dependency provider for openfeign (org.springframework.cloud:spring-cloud-openfeign-core)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getOpenfeign() { return create("spring.cloud.openfeign"); }

        /**
         * Returns the group of libraries at spring.cloud.starter
         */
        public SpringCloudStarterLibraryAccessors getStarter() { return laccForSpringCloudStarterLibraryAccessors; }

    }

    public static class SpringCloudStarterLibraryAccessors extends SubDependencyFactory {

        public SpringCloudStarterLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for openfeign (org.springframework.cloud:spring-cloud-starter-openfeign)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getOpenfeign() { return create("spring.cloud.starter.openfeign"); }

    }

    public static class SpringDataLibraryAccessors extends SubDependencyFactory {

        public SpringDataLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for commons (org.springframework.data:spring-data-commons)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getCommons() { return create("spring.data.commons"); }

            /**
             * Creates a dependency provider for jpa (org.springframework.data:spring-data-jpa)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getJpa() { return create("spring.data.jpa"); }

    }

    public static class SpringSecurityLibraryAccessors extends SubDependencyFactory {
        private final SpringSecurityOauth2LibraryAccessors laccForSpringSecurityOauth2LibraryAccessors = new SpringSecurityOauth2LibraryAccessors(owner);

        public SpringSecurityLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for core (org.springframework.security:spring-security-core)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getCore() { return create("spring.security.core"); }

        /**
         * Returns the group of libraries at spring.security.oauth2
         */
        public SpringSecurityOauth2LibraryAccessors getOauth2() { return laccForSpringSecurityOauth2LibraryAccessors; }

    }

    public static class SpringSecurityOauth2LibraryAccessors extends SubDependencyFactory {

        public SpringSecurityOauth2LibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

            /**
             * Creates a dependency provider for core (org.springframework.security:spring-security-oauth2)
             * This dependency was declared in catalog libs.versions.toml
             */
            public Provider<MinimalExternalModuleDependency> getCore() { return create("spring.security.oauth2.core"); }

    }

    public static class VersionAccessors extends VersionFactory  {

        public VersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

            /**
             * Returns the version associated to this alias: boot (2.+)
             * If the version is a rich version and that its not expressible as a
             * single version string, then an empty string is returned.
             * This version was declared in catalog libs.versions.toml
             */
            public Provider<String> getBoot() { return getVersion("boot"); }

            /**
             * Returns the version associated to this alias: chassis (4.+)
             * If the version is a rich version and that its not expressible as a
             * single version string, then an empty string is returned.
             * This version was declared in catalog libs.versions.toml
             */
            public Provider<String> getChassis() { return getVersion("chassis"); }

            /**
             * Returns the version associated to this alias: cloud (2021.0.3)
             * If the version is a rich version and that its not expressible as a
             * single version string, then an empty string is returned.
             * This version was declared in catalog libs.versions.toml
             */
            public Provider<String> getCloud() { return getVersion("cloud"); }

            /**
             * Returns the version associated to this alias: dgs (5.0.+)
             * If the version is a rich version and that its not expressible as a
             * single version string, then an empty string is returned.
             * This version was declared in catalog libs.versions.toml
             */
            public Provider<String> getDgs() { return getVersion("dgs"); }

            /**
             * Returns the version associated to this alias: immutables (2.+)
             * If the version is a rich version and that its not expressible as a
             * single version string, then an empty string is returned.
             * This version was declared in catalog libs.versions.toml
             */
            public Provider<String> getImmutables() { return getVersion("immutables"); }

    }

    public static class BundleAccessors extends BundleFactory {
        private final JacksonBundleAccessors baccForJacksonBundleAccessors = new JacksonBundleAccessors(providers, config);
        private final SpringBundleAccessors baccForSpringBundleAccessors = new SpringBundleAccessors(providers, config);
        private final TestBundleAccessors baccForTestBundleAccessors = new TestBundleAccessors(providers, config);

        public BundleAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Returns the group of bundles at bundles.jackson
         */
        public JacksonBundleAccessors getJackson() { return baccForJacksonBundleAccessors; }

        /**
         * Returns the group of bundles at bundles.spring
         */
        public SpringBundleAccessors getSpring() { return baccForSpringBundleAccessors; }

        /**
         * Returns the group of bundles at bundles.test
         */
        public TestBundleAccessors getTest() { return baccForTestBundleAccessors; }

    }

    public static class JacksonBundleAccessors extends BundleFactory {

        public JacksonBundleAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

            /**
             * Creates a dependency bundle provider for jackson.config which is an aggregate for the following dependencies:
             * <ul>
             *    <li>com.fasterxml.jackson.core:jackson-core</li>
             *    <li>com.fasterxml.jackson.module:jackson-module-parameter-names</li>
             * </ul>
             * This bundle was declared in catalog libs.versions.toml
             */
            public Provider<ExternalModuleDependencyBundle> getConfig() { return createBundle("jackson.config"); }

    }

    public static class SpringBundleAccessors extends BundleFactory {

        public SpringBundleAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

            /**
             * Creates a dependency bundle provider for spring.test which is an aggregate for the following dependencies:
             * <ul>
             *    <li>org.springframework:spring-test</li>
             *    <li>org.springframework.boot:spring-boot-test</li>
             *    <li>org.springframework.boot:spring-boot-autoconfigure</li>
             *    <li>org.springframework.boot:spring-boot-test-autoconfigure</li>
             * </ul>
             * This bundle was declared in catalog libs.versions.toml
             */
            public Provider<ExternalModuleDependencyBundle> getTest() { return createBundle("spring.test"); }

    }

    public static class TestBundleAccessors extends BundleFactory {

        public TestBundleAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

            /**
             * Creates a dependency bundle provider for test.api which is an aggregate for the following dependencies:
             * <ul>
             *    <li>org.assertj:assertj-core</li>
             *    <li>org.junit.jupiter:junit-jupiter-params</li>
             *    <li>org.junit.jupiter:junit-jupiter-api</li>
             * </ul>
             * This bundle was declared in catalog libs.versions.toml
             */
            public Provider<ExternalModuleDependencyBundle> getApi() { return createBundle("test.api"); }

            /**
             * Creates a dependency bundle provider for test.runtime which is an aggregate for the following dependencies:
             * <ul>
             *    <li>org.junit.jupiter:junit-jupiter-engine</li>
             *    <li>org.junit.jupiter:junit-jupiter</li>
             * </ul>
             * This bundle was declared in catalog libs.versions.toml
             */
            public Provider<ExternalModuleDependencyBundle> getRuntime() { return createBundle("test.runtime"); }

    }

    public static class PluginAccessors extends PluginFactory {

        public PluginAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

            /**
             * Creates a plugin provider for boot to the plugin id 'org.springframework.boot'
             * This plugin was declared in catalog libs.versions.toml
             */
            public Provider<PluginDependency> getBoot() { return createPlugin("boot"); }

            /**
             * Creates a plugin provider for detekt to the plugin id 'io.gitlab.arturbosch.detekt'
             * This plugin was declared in catalog libs.versions.toml
             */
            public Provider<PluginDependency> getDetekt() { return createPlugin("detekt"); }

            /**
             * Creates a plugin provider for kotlin to the plugin id 'org.jetbrains.kotlin.jvm'
             * This plugin was declared in catalog libs.versions.toml
             */
            public Provider<PluginDependency> getKotlin() { return createPlugin("kotlin"); }

            /**
             * Creates a plugin provider for ktlint to the plugin id 'org.jlleitschuh.gradle.ktlint'
             * This plugin was declared in catalog libs.versions.toml
             */
            public Provider<PluginDependency> getKtlint() { return createPlugin("ktlint"); }

    }

}
