import org.gradle.api.tasks.testing.logging.TestLogEvent

plugins {
  `java-library`
}

dependencies {
  implementation(platform(libs.spring.platform))
  implementation(libs.spring.boot.starter.jpa)
  testImplementation(libs.bundles.test.api)
  testImplementation(libs.bundles.spring.test)
  testRuntimeOnly(libs.bundles.test.runtime)
  testRuntimeOnly(libs.h2)
}

tasks.test {
  useJUnitPlatform()

  testLogging {
    lifecycle {
      showStandardStreams = true
      displayGranularity = 2
      events.addAll(listOf(TestLogEvent.STARTED, TestLogEvent.PASSED, TestLogEvent.SKIPPED, TestLogEvent.FAILED))
    }
  }
  reports {
    html.required.set(false)
    junitXml.required.set(false)
  }
}
