package example;

import org.springframework.data.annotation.CreatedDate;

import javax.persistence.*;
import java.time.OffsetDateTime;
import java.util.UUID;

@Entity
public class MyEntity  {
  private UUID id = UUID.randomUUID();

  void setId(UUID id) {
    this.id = id;
  }

  @Id
  @Access(AccessType.PROPERTY)
  @Column(columnDefinition = "uuid", nullable = false, updatable = false, unique = true)
  public UUID getId() {
    return id;
  }

  @CreatedDate
  private OffsetDateTime created;

  @Column(name = "created_on", columnDefinition = "timestamp with time zone", nullable = false, updatable = false)
  public OffsetDateTime getCreated() {
    return created;
  }

  void setCreated(OffsetDateTime created) {
    this.created = created;
  }

}
