package example;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;

import static org.assertj.core.api.Assertions.assertThat;

@DataJpaTest
public class MyEntityRepositoryTest {

  @Test
  void testSave(@Autowired MyEntityRepository repo ) {
    var saved = repo.save(new MyEntity());

    assertThat(saved).extracting(MyEntity::getId).isNotNull();

    var found = repo.findAll();

    assertThat(found).extracting(MyEntity::getId).contains(saved.getId());
    assertThat(found).first().extracting(MyEntity::getCreated).isNotNull();
  }
}
