import 'package:flutter/material.dart';
import 'package:syncfusion_flutter_charts/charts.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter Demo',
      theme: ThemeData(
        colorScheme: ColorScheme.fromSeed(seedColor: Colors.deepPurple),
        useMaterial3: true,
      ),
      home: const MyHomePage(),
    );
  }
}

class MyHomePage extends StatefulWidget {
  const MyHomePage({super.key});
  @override
  State<MyHomePage> createState() => _MyHomePageState();
}

class _MyHomePageState extends State<MyHomePage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Theme.of(context).colorScheme.inversePrimary,
      ),
      body: SfCartesianChart(
        legend: const Legend(isVisible: true),
        primaryXAxis: DateTimeAxis(
          minimum: DateTime(2023, 01, 01),
          maximum: DateTime(2023, 02, 01),
          interval: 1,
        ),
        series: <CartesianSeries>[
          ColumnSeries<SalesData, DateTime>(
            dataSource: <SalesData>[
              //SalesData(DateTime(2023, 01, 01), 35),
              SalesData(DateTime(2023, 01, 05), 28),
              //SalesData(DateTime(2023, 01, 03), 34),
              //SalesData(DateTime(2023, 01, 04), 32),
              //SalesData(DateTime(2023, 01, 05), 40),
              SalesData(DateTime(2023, 01, 20), 40)
            ],
            xValueMapper: (SalesData sales, _) => sales.year,
            yValueMapper: (SalesData sales, _) => sales.sales,
          ),
          /* LineSeries<SalesData, DateTime>(
            dataSource: <SalesData>[
              SalesData(DateTime(2023, 01, 01), 35),
              SalesData(DateTime(2023, 01, 02), 28),
              SalesData(DateTime(2023, 01, 03), 34),
              SalesData(DateTime(2023, 01, 04), 32),
              SalesData(DateTime(2023, 01, 05), 40)
            ],
            xValueMapper: (SalesData sales, _) => sales.year,
            yValueMapper: (SalesData sales, _) => sales.sales,
          ), */
        ],
      ),
    );
  }
}

class SalesData {
  SalesData(this.year, this.sales);
  final DateTime year;
  final double sales;
}

class NewPage extends StatelessWidget {
  const NewPage({super.key});
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Theme.of(context).colorScheme.inversePrimary,
      ),
      body: const Center(
        child: Text('New Page'),
      ),
    );
  }
}
