from dataclasses import dataclass, field
from decimal import Decimal
from enum import Enum
from typing import List, Optional
from xsdata.models.datatype import XmlDate, XmlDateTime

__NAMESPACE__ = "http://www.brz.gv.at/datenverbund-unis"


@dataclass
class ErnpMeldungV2:
    dokumentnr: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 255,
        }
    )
    dokumenttyp: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 255,
        }
    )
    ausgabedatum: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    ausstell_behoerde: Optional[str] = field(
        default=None,
        metadata={
            "name": "ausstellBehoerde",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    ausstellland: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


class JaNeinStr(Enum):
    J = "j"
    J_1 = "J"
    N = "n"
    N_1 = "N"


@dataclass
class KontingentBlock:
    anzahl: int = field(
        default=1,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[UPFR][A-Z]",
        }
    )
    sj: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


class LehrgangMeldungFhStudstatuscode(Enum):
    VALUE_1 = 1
    VALUE_2 = 2
    VALUE_3 = 3
    VALUE_4 = 4
    VALUE_5 = 5


class Matrikelstatus(Enum):
    UNGUELTIG = "ungueltig"
    GUELTIG = "gueltig"
    RESERVIERBAR = "reservierbar"
    RESERVIERT = "reserviert"
    ZUGEORDNET = "zugeordnet"
    VERGEBEN = "vergeben"
    STORNIERT = "storniert"
    RECHTSKRAEFTIG = "rechtskraeftig"
    GESPERRT = "gesperrt"
    GELOESCHT = "geloescht"


@dataclass
class PersonMeldungV2:
    """
    :ivar be:
    :ivar matrikel: Element 'matrikel' ist veraltet und wird in der
        nächsten API-Version entfernt. Bitte ausschließlich Element
        'matrikelnummer' verwenden!!!
    :ivar matrikelnummer:
    :ivar vorname:
    :ivar nachname:
    :ivar geschlecht:
    :ivar gebdat:
    :ivar svnr:
    :ivar plz:
    :ivar staat:
    :ivar adresse_ausland: In Übergangsphase optional. Ab API 0.8
        obligat!
    :ivar matura:
    :ivar writeonerror:
    :ivar bpk:
    """
    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[UPFR][A-Z]",
        }
    )
    matrikel: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    matrikelnummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    vorname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 255,
        }
    )
    nachname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 255,
        }
    )
    geschlecht: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[MWXOIK]",
        }
    )
    gebdat: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    svnr: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"([A-Z]{4}[0-9]{6})|(\d{10})",
        }
    )
    plz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[ -~]{0,25}",
        }
    )
    staat: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 3,
            "pattern": r"[A-Z ]{1,3}",
        }
    )
    adresse_ausland: Optional[str] = field(
        default=None,
        metadata={
            "name": "adresseAusland",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_length": 3,
            "max_length": 255,
        }
    )
    matura: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    writeonerror: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    bpk: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"([A-Za-z0-9+/]{27})=",
        }
    )


@dataclass
class StudienberechtigungBasis:
    matrikelnummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    fallnr: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    svnr: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"\d{10}",
        }
    )
    ekz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[A-Z]{4}[0-9]{6}",
        }
    )
    bpk: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"([A-Za-z0-9+/]{27})=",
        }
    )
    geburtsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    geschlecht: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[MWXOIK]",
        }
    )
    staatsbuergerschaft: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 3,
            "pattern": r"[A-Z ]{1,3}",
        }
    )
    zulassungsantragdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    pruefungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Studierendenkey:
    """
    :ivar matrikel: Element 'matrikel' ist veraltet und wird in der
        nächsten API-Version entfernt. Bitte ausschließlich Element
        'matrikelnummer' verwenden!!!
    :ivar matrikelnummer:
    :ivar be: Ersetzt im Webservice-API grundsätzlich die FH-
        Erhalterkennung. Bei Weitermeldung an BIS wird die BE-Kennung
        automatisch in eine Erhalterkennung transformiert (u.U.).
    :ivar semester: Ist auch bei Meldungen von FH obligat! Ergibt sich
        bei BIS-Meldungen aus dem aktuellen Meldefenster (z.B. BIS-
        Meldung April 2020 = DVUH Sommersemester 2020 = "2020S"
    """
    matrikel: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    matrikelnummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[UPFR][A-Z]",
        }
    )
    semester: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-9]{4}[SW]",
        }
    )


class StudiumMeldungFhAusbildungssemester(Enum):
    VALUE_1 = 1
    VALUE_2 = 2
    VALUE_3 = 3
    VALUE_4 = 4
    VALUE_5 = 5
    VALUE_6 = 6
    VALUE_7 = 7
    VALUE_8 = 8
    VALUE_50 = 50
    VALUE_60 = 60


class StudiumMeldungFhBerufstaetigkeitcode(Enum):
    VALUE_0 = 0
    VALUE_2 = 2
    VALUE_3 = 3
    VALUE_6 = 6
    VALUE_7 = 7
    VALUE_9 = 9
    VALUE_10 = 10


class StudiumMeldungFhStudstatuscode(Enum):
    VALUE_1 = 1
    VALUE_2 = 2
    VALUE_3 = 3
    VALUE_4 = 4
    VALUE_5 = 5


class StudiumMeldungSchliessungsgrund(Enum):
    A = "A"
    B = "B"
    C = "C"
    D = "D"


@dataclass
class Abschluss:
    class Meta:
        name = "abschluss"

    abschlussart: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[RWSPU ]",
        }
    )
    fach: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_inclusive": 1,
            "max_inclusive": 2,
        }
    )
    abschlussdatum: List[XmlDate] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
        }
    )


@dataclass
class AbstractAnfrage:
    class Meta:
        name = "abstractAnfrage"

    uuid: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"NULL|[0-9|a-f|A-F]{8}-[0-9|a-f|A-F]{4}-[0-9|a-f|A-F]{4}-[0-9|a-f|A-F]{4}-[0-9|a-f|A-F]{12}",
        }
    )


class Adresstyp(Enum):
    H = "H"
    S = "S"


class Bezahlstatus(Enum):
    VALUE_0 = "0"
    VALUE_1 = "1"
    VALUE_2 = "2"
    VALUE_7 = "7"
    VALUE_8 = "8"
    VALUE_9 = "9"


@dataclass
class ClearingAdresse:
    class Meta:
        name = "clearingAdresse"

    staat: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 3,
        }
    )
    plz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[ -~]{0,25}",
        }
    )
    ort: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 3,
            "max_length": 255,
        }
    )
    strasse: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 3,
            "max_length": 255,
        }
    )


@dataclass
class Datenfeld:
    class Meta:
        name = "datenfeld"

    value: str = field(
        default="",
        metadata={
            "required": True,
        }
    )
    id: Optional[str] = field(
        default=None,
        metadata={
            "type": "Attribute",
            "pattern": r"[0-9]{2}",
        }
    )
    label: Optional[str] = field(
        default=None,
        metadata={
            "type": "Attribute",
        }
    )


class EctsBezug(Enum):
    GESAMT = "gesamt"
    ERWORBEN = "erworben"
    ANGERECHNET = "angerechnet"


@dataclass
class EmailadresseMitTyp:
    class Meta:
        name = "emailadresseMitTyp"

    typ: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    adresse: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


class EmailtypTyp(Enum):
    BE = "BE"
    PR = "PR"


class FehlerquelleWerprueft(Enum):
    BRZ = "BRZ"
    BMGES = "BMGES"
    BIS = "BIS"


@dataclass
class Fehlerref:
    class Meta:
        name = "fehlerref"

    datenfeld: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    referenz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class GemeinsamTyp:
    """
    :ivar mobilitaetprogrammcode:
    :ivar programmnr:
    :ivar studtyp:
    :ivar partnercode:
    :ivar ausbildungssemester: Bei Einbettung in StudiumMeldungFH ist
        das Element verpflichtend, bei LehrgangMeldung ist es optional.
    :ivar studstatuscode:
    :ivar beendigungsdatum:
    :ivar studienkennunguni:
    """
    class Meta:
        name = "gemeinsamTyp"

    mobilitaetprogrammcode: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    programmnr: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    studtyp: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    partnercode: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_inclusive": 0,
            "max_inclusive": 99999,
        }
    )
    ausbildungssemester: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studstatuscode: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    beendigungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studienkennunguni: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"^[AFHLU][UPF][A-Z]([0-9]{3}){1,3}(0[1-6]|[UP][A-W]){0,1} *$",
        }
    )


@dataclass
class Identification:
    class Meta:
        name = "identification"

    value: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    type_value: Optional[str] = field(
        default=None,
        metadata={
            "name": "type",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class KennzahlTyp:
    class Meta:
        name = "kennzahlTyp"

    bezeichnung: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    wert: Optional[Decimal] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    id: Optional[str] = field(
        default=None,
        metadata={
            "type": "Attribute",
        }
    )
    unistev_kuerzel: Optional[str] = field(
        default=None,
        metadata={
            "name": "unistev-kuerzel",
            "type": "Attribute",
        }
    )


@dataclass
class Matrikelnummernliste:
    class Meta:
        name = "matrikelnummernliste"

    matrikelnummer: List[str] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


class MobiZweckTyp(Enum):
    VALUE_1 = 1
    VALUE_2 = 2
    VALUE_3 = 3


@dataclass
class Mobilitaet:
    class Meta:
        name = "mobilitaet"

    programm: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    staat: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 3,
            "pattern": r"[A-Z ]{1,3}",
        }
    )


class MobilitaetFhAufenthaltfoerderungcode(Enum):
    VALUE_1 = 1
    VALUE_2 = 2
    VALUE_3 = 3
    VALUE_4 = 4
    VALUE_5 = 5


class OrgformTyp(Enum):
    VALUE_1 = 1
    VALUE_2 = 2
    VALUE_3 = 3


@dataclass
class PhPersonId:
    class Meta:
        name = "phPersonId"

    bpk: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"([A-Za-z0-9+/]{27})=",
        }
    )
    personenkennzeichen: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    matrikelnummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    svnr: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"\d{10}",
        }
    )
    ekz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[A-Z]{4}[0-9]{6}",
        }
    )


class PruefungMobilitaetsbonus(Enum):
    B = "B"


class RefundierungsartTyp(Enum):
    """
    :cvar VALUE_1: Zahlungsrelevante Refundierung mit Beitragsabsenkung
    :cvar VALUE_2: Refundierung ohne Beitragsabsenkung
    """
    VALUE_1 = 1
    VALUE_2 = 2


@dataclass
class Returntext:
    class Meta:
        name = "returntext"

    text: List[str] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Rueckgabewert:
    class Meta:
        name = "rueckgabewert"

    responsecode: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "max_length": 3,
        }
    )
    responsetext: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class StudentInfoHuelle:
    class Meta:
        name = "studentInfoHuelle"


class StudentInfoMitbelegungZaehlungPePn(Enum):
    E = "E"
    N = "N"


class StudentInfoMitbelegungZaehlungPo(Enum):
    O = "O"


class StudentInfoZaehlungPePn(Enum):
    E = "E"
    N = "N"


class StudentInfoZaehlungPo(Enum):
    O = "O"


@dataclass
class Studienkennung:
    """
    :ivar studiengesetz:
    :ivar bezulassung:
    :ivar skz1: UNI/PH: Kopfcode oder einfache Studienkennung, FH: Erste
        Ziffer der FH-Studienkennung mit "00" vorangestellt (dzt.
        entweder "000" oder "009").
    :ivar skz2: UNI/PH: KZ2 (Element entfällt, falls Studienbild nur KZ1
        hat), FH: Ziffer 2-4 der FH-Studienkennung.
    :ivar skz3: UNI/PH: KZ3, falls vorhanden (ansonsten entfällt das
        ELement), FH: Element entfällt grundsätzlich.
    :ivar bezwei: Entfällt grundsätzlich bei FH
    """
    class Meta:
        name = "studienkennung"

    studiengesetz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[AUHL]",
        }
    )
    bezulassung: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[UPFR][A-Za-z]",
        }
    )
    skz1: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-9]{3}",
        }
    )
    skz2: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-9]{3}",
        }
    )
    skz3: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-9]{3}",
        }
    )
    bezwei: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[A-Wa-z1-9]|[UPFR][A-Wa-z]|0[1-9]",
        }
    )


@dataclass
class Studienplan:
    class Meta:
        name = "studienplan"

    fach1: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-9]{4}[SW]",
        }
    )
    fach2: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-9]{4}[SW]",
        }
    )


@dataclass
class Vorschreibung:
    class Meta:
        name = "vorschreibung"

    oehbeitrag: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "max_inclusive": 9999,
        }
    )
    sonderbeitrag: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "max_inclusive": 9999,
        }
    )
    studienbeitrag: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "max_inclusive": 99999,
        }
    )
    studiengebuehr: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "max_inclusive": 9999999,
        }
    )
    valutadatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "max_inclusive": XmlDate(2099, 9, 1),
        }
    )
    studienbeitragnachfrist: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "max_inclusive": 99999,
        }
    )
    studiengebuehrnachfrist: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "max_inclusive": 9999999,
        }
    )
    valutadatumnachfrist: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "max_inclusive": XmlDate(2099, 9, 1),
        }
    )


@dataclass
class Zugangsberechtigung:
    class Meta:
        name = "zugangsberechtigung"

    voraussetzung: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"^[0-9]{2,3}$|^ {0,2}$",
        }
    )
    datum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    staat: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class AenderungsdienstTyp:
    matrikelnummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    semester: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-9]{4}[SW]",
        }
    )
    studienkennung: Optional[Studienkennung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class ApiStatus(AbstractAnfrage):
    apiversion: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    buildversion: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    contextroot: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    offlinestatus: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    loadfactor: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    issues: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class ExtendedStudierendenKey:
    """
    :ivar matrikel: Element 'matrikel' ist veraltet und wird in der
        nächsten API-Version entfernt. Bitte ausschließlich Element
        'matrikelnummer' verwenden!!!
    :ivar matrikelnummer:
    :ivar be:
    :ivar semester:
    :ivar matrikelstatus:
    :ivar fullstudentlink:
    """
    matrikel: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    matrikelnummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[UPFR][A-Z]",
        }
    )
    semester: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-9]{4}[SW]",
        }
    )
    matrikelstatus: Optional[Matrikelstatus] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    fullstudentlink: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class KontostandBasis:
    bezahlstatus: Optional[Bezahlstatus] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    kontostand: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    buchungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    buchungsbe: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class LehrgangMeldungFh:
    """
    :ivar lehrgangsnr:
    :ivar perskz:
    :ivar studstatuscode:
    :ivar meldestatus: Optional ab AIP 0.6, verpflichtend in API 0.7!
        I=Inländer, A=Ausländer, U=Unterbrecher, O=Storno, BLANK=nicht
        fortgesetzt.
    :ivar standortcode:
    :ivar zulassungsdatum:
    :ivar beendigungsdatum:
    :ivar zugangsberechtigung:
    :ivar zugangsberechtigung_ma:
    :ivar studstatuscodestichtag:
    :ivar beendigungsdatumstichtag:
    :ivar meldestatusstichtag: Meldestatus zum aktuellen BIS-Stichtag.
        Falls das Element fehlt, wird der Wert von meldestatus der
        letzten Meldung vor dem Stichtag angenommen.
    :ivar gemeinsam: Nicht zulässig, wenn disloziert=J
    :ivar orgformcode:
    """
    class Meta:
        name = "LehrgangMeldungFH"

    lehrgangsnr: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"\d{7}",
        }
    )
    perskz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"\d{10}",
        }
    )
    studstatuscode: Optional[LehrgangMeldungFhStudstatuscode] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    meldestatus: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "white_space": "preserve",
            "pattern": r"[ IUAO]",
        }
    )
    standortcode: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    zulassungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    beendigungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    zugangsberechtigung: Optional[Zugangsberechtigung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    zugangsberechtigung_ma: Optional[Zugangsberechtigung] = field(
        default=None,
        metadata={
            "name": "zugangsberechtigungMA",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studstatuscodestichtag: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    beendigungsdatumstichtag: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    meldestatusstichtag: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "white_space": "preserve",
            "pattern": r"[ IUAO]",
        }
    )
    gemeinsam: List[GemeinsamTyp] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    orgformcode: Optional[OrgformTyp] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class MatrikelMeldungAnfrage(AbstractAnfrage):
    personmeldung: Optional[PersonMeldungV2] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    ernpmeldung: Optional[ErnpMeldungV2] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class MatrikelReservierenAnfrage(AbstractAnfrage):
    kontingentblock: Optional[KontingentBlock] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class StudienberechtigungFh(StudienberechtigungBasis):
    class Meta:
        name = "StudienberechtigungFH"

    studienberechtiungsgruppe: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_inclusive": 1,
            "max_inclusive": 10,
        }
    )


@dataclass
class StudiumMeldung:
    """Meldung von Studien gemäß Universitäts- oder Hochschulgesetz.

    Für Meldungen gemäß Fachhochschulgesezt verwenden Sie
    `StudiumMeldungFH` oder `LehrgangMeldungFH`.

    :ivar studienkennung:
    :ivar studienplan:
    :ivar zulassungsdatum:
    :ivar zulassungsstatus:
    :ivar beendigungsdatum:
    :ivar anfaenger1:
    :ivar anfaenger2:
    :ivar meldestatus: Element ist im Batch-Szenario unter dem Namen
        "Fortsetzungskennzeichen" bekannt.
    :ivar zugangsberechtigung:
    :ivar mobilitaet: Ab API 0.5 kann "von"/"bis" angegeben werden.
        Damit sind ggf. auch meherer Mobilitäten pro Semester und
        Studium zu unterscheiden.
    :ivar schliessungsgrund: Schließungsgrund gem. UHSBV 2023.
        Pflichtfeld ab API 0.8
    """
    studienkennung: Optional[Studienkennung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    studienplan: Optional[Studienplan] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    zulassungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    zulassungsstatus: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[BFXV]",
        }
    )
    beendigungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    anfaenger1: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"^[A ]{0,1}$",
        }
    )
    anfaenger2: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"^[A ]{0,1}$",
        }
    )
    meldestatus: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "white_space": "preserve",
            "pattern": r"[ IUAO]",
        }
    )
    zugangsberechtigung: Optional[Zugangsberechtigung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    mobilitaet: Optional[Mobilitaet] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    schliessungsgrund: Optional[StudiumMeldungSchliessungsgrund] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Abschluesse:
    class Meta:
        name = "abschluesse"

    abschluss: List[Abschluss] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Adresse:
    class Meta:
        name = "adresse"

    strasse: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    plz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[ -~]{0,25}",
        }
    )
    ort: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    staat: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 3,
            "pattern": r"[A-Z ]{1,3}",
        }
    )
    typ: Optional[Adresstyp] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    coname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Datensatz:
    class Meta:
        name = "datensatz"

    feld: List[Datenfeld] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 3,
        }
    )


@dataclass
class EkzBasisdaten:
    class Meta:
        name = "ekzBasisdaten"

    vorname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "max_length": 80,
            "white_space": "collapse",
        }
    )
    nachname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "max_length": 80,
            "white_space": "collapse",
        }
    )
    geschlecht: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[MWXOIK]",
        }
    )
    geb_datum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "name": "gebDatum",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    svnr: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "white_space": "collapse",
        }
    )
    adresse: Optional[ClearingAdresse] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    request_timestamp: Optional[XmlDateTime] = field(
        default=None,
        metadata={
            "name": "requestTimestamp",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    org_key: Optional[str] = field(
        default=None,
        metadata={
            "name": "orgKey",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class EmailMitTyp:
    class Meta:
        name = "emailMitTyp"

    emailadresse: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_length": 0,
            "max_length": 255,
        }
    )
    emailtyp: Optional[EmailtypTyp] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class EmailadressenListe:
    class Meta:
        name = "emailadressenListe"

    email: List[EmailadresseMitTyp] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
        }
    )


@dataclass
class Fehlerquelle:
    """
    :ivar studierendenkey:
    :ivar studiumkey: Nur für Universitäten und Pädagogische
        Hochschulen!
    :ivar stgkz: Nur für Fachhochschulen (bei Lehrgängen mit LG-Nr.
        besetzen)
    :ivar datenfeld:
    :ivar datum: Ab API 0.6 Pflichtfeld, bis API 0.5 optional.
    :ivar werprueft:
    """
    class Meta:
        name = "fehlerquelle"

    studierendenkey: Optional[Studierendenkey] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    studiumkey: Optional[Studienkennung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    stgkz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"\d{7}",
        }
    )
    datenfeld: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    datum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    werprueft: Optional[FehlerquelleWerprueft] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Kennzahlenliste:
    class Meta:
        name = "kennzahlenliste"

    kennzahl: List[KennzahlTyp] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Attribute",
            "pattern": r"[UPFR][A-Z]",
        }
    )
    semester: Optional[str] = field(
        default=None,
        metadata={
            "type": "Attribute",
            "pattern": r"[0-9]{4}[SW]",
        }
    )
    studienjahr: Optional[str] = field(
        default=None,
        metadata={
            "type": "Attribute",
        }
    )
    datenstand: Optional[str] = field(
        default=None,
        metadata={
            "type": "Attribute",
        }
    )


@dataclass
class MobilitaetVonBis(Mobilitaet):
    class Meta:
        name = "mobilitaetVonBis"

    von: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    bis: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Nachweis:
    class Meta:
        name = "nachweis"

    studierendenkey: Optional[Studierendenkey] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    code: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[FHNRTVZ]",
        }
    )
    dauer: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_inclusive": 0,
            "max_inclusive": 99,
        }
    )
    einbringung: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    gueltig: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[JNjn]",
        }
    )


@dataclass
class Person:
    class Meta:
        name = "person"

    person_id: Optional[PhPersonId] = field(
        default=None,
        metadata={
            "name": "personId",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    vorname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 255,
        }
    )
    nachname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 255,
        }
    )
    geb_datum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "name": "gebDatum",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    geschlecht: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[MWXOIKmwxoik]",
        }
    )
    zustelladresse: Optional[ClearingAdresse] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    heimatadresse: Optional[ClearingAdresse] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    studstatuscode: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[12345]",
        }
    )


@dataclass
class Pruefung:
    """
    :ivar fach: Bei FH Default=1
    :ivar semesterzahl: Bei FH Default=1
    :ivar semesterstunden: Bei FH Default=0
    :ivar semesterstundenpositiv: Bei FH Default=0
    :ivar ects:
    :ivar mobilitaetsbonus:
    """
    class Meta:
        name = "pruefung"

    fach: int = field(
        default=1,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_inclusive": 1,
            "max_inclusive": 2,
        }
    )
    semesterzahl: int = field(
        default=1,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    semesterstunden: Decimal = field(
        default=Decimal("0.0"),
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_inclusive": Decimal("0"),
            "max_inclusive": Decimal("99.9"),
            "total_digits": 3,
            "fraction_digits": 1,
            "white_space": "collapse",
        }
    )
    semesterstundenpositiv: Decimal = field(
        default=Decimal("0.0"),
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_inclusive": Decimal("0"),
            "max_inclusive": Decimal("99.9"),
            "total_digits": 3,
            "fraction_digits": 1,
            "white_space": "collapse",
        }
    )
    ects: List["Pruefung.Ects"] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
            "max_occurs": 2,
        }
    )
    mobilitaetsbonus: Optional[PruefungMobilitaetsbonus] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )

    @dataclass
    class Ects:
        """
        :ivar value:
        :ivar bezug: FH notieren je ein Element mit "erworben" und
            "angerechnet". Bei UNI/PH entfällt das Attribut.
        """
        value: str = field(
            default="",
            metadata={
                "required": True,
                "min_inclusive": "0",
                "max_inclusive": "250",
                "total_digits": 3,
                "fraction_digits": 1,
                "white_space": "collapse",
                "pattern": r"^[0-9]{1,3}(|[,.][0-9]{1})$",
            }
        )
        bezug: EctsBezug = field(
            default=EctsBezug.GESAMT,
            metadata={
                "type": "Attribute",
            }
        )


@dataclass
class Refundierungsmeldung:
    class Meta:
        name = "refundierungsmeldung"

    studierendenkey: Optional[Studierendenkey] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    refundierungsart: Optional[RefundierungsartTyp] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    refundierungsbetrag: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_inclusive": 1,
            "max_inclusive": 999999,
        }
    )
    durchfuehrungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    durchfuerungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    refundierungsbe: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 2,
            "max_length": 2,
            "pattern": r"[UPFR][A-Z]",
        }
    )
    verfahrensstatus: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_length": 1,
            "max_length": 1,
            "pattern": r"[ ABS]",
        }
    )
    bearbeitungsname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    referenznummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[\p{L}\p{N}\p{P}\s\+]{3,255}",
        }
    )


@dataclass
class SimplePhysicalPerson:
    class Meta:
        name = "simplePhysicalPerson"

    identification: Optional[Identification] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    akad_grad_pre: Optional[str] = field(
        default=None,
        metadata={
            "name": "akadGradPre",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[A-Za-z.\-/,'´`() À-ž&]{0,255}",
        }
    )
    vorname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    nachname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    akad_grad_post: Optional[str] = field(
        default=None,
        metadata={
            "name": "akadGradPost",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[A-Za-z.\-/,'´`() À-ž&]{0,255}",
        }
    )
    alternativname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    geschlecht: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[MWXOIK]",
        }
    )
    gebdat: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    gebland: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    staat: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class StudentInfoMinimal(StudentInfoHuelle):
    class Meta:
        name = "studentInfoMinimal"

    vorname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 255,
        }
    )
    nachname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_length": 1,
            "max_length": 255,
        }
    )
    geburtsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    geschlecht: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[MWXOIK]",
        }
    )


@dataclass
class Studienberechtigung(StudienberechtigungBasis):
    class Meta:
        name = "studienberechtigung"

    skz1: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-9]{3}",
        }
    )
    skz2: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-9]{3}",
        }
    )
    skz3: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-9]{3}",
        }
    )


@dataclass
class UniSemesterAnfrage(AbstractAnfrage):
    class Meta:
        name = "uniSemesterAnfrage"

    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[UPFR][A-Z]",
        }
    )
    semester: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-9]{4}[SW]",
        }
    )


@dataclass
class UniStudentAnfrage(AbstractAnfrage):
    class Meta:
        name = "uniStudentAnfrage"

    studierendenkey: Optional[Studierendenkey] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class BpkantwortSatz(Datensatz):
    class Meta:
        name = "BPKAntwortSatz"


@dataclass
class Kontostand(KontostandBasis):
    studierendenkey: Optional[Studierendenkey] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class MatrikelListe:
    extendedstudierendenkey: List[ExtendedStudierendenKey] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class NachweisAnfrage(AbstractAnfrage):
    nachweis: Optional[Nachweis] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class StudentInfoEkz(StudentInfoMinimal):
    svnr: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    adresse: Optional[Adresse] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    request_timestamp: Optional[XmlDate] = field(
        default=None,
        metadata={
            "name": "requestTimestamp",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    org_key: Optional[str] = field(
        default=None,
        metadata={
            "name": "orgKey",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class StudienDatenFh:
    """Liste von Studien ohne Prüfungsdaten.

    Verwende diese Variante bei der Meldung neuer Studiendaten von
    Fachhochschulen, wenn die Prüfungsdaten bereits in einem anderen
    Element dargestellt werden.
    """
    class Meta:
        name = "StudienDatenFH"

    studium: List[StudiumMeldung] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
        }
    )


@dataclass
class AdressenListe:
    class Meta:
        name = "adressenListe"

    adresse: List[Adresse] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
        }
    )


@dataclass
class Aenderungsdienst(AenderungsdienstTyp):
    class Meta:
        name = "aenderungsdienst"
        namespace = "http://www.brz.gv.at/datenverbund-unis"


@dataclass
class EkzForcierung:
    class Meta:
        name = "ekzForcierung"

    forcierungskey: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    ekz_basis: Optional[EkzBasisdaten] = field(
        default=None,
        metadata={
            "name": "ekzBasis",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    ekz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "white_space": "collapse",
        }
    )
    returncode: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    returntext: Optional[Returntext] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class EmailListe:
    class Meta:
        name = "emailListe"

    email: List[EmailMitTyp] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Fehler:
    """
    :ivar fehlernummer:
    :ivar kategorie:
    :ivar fehlertext:
    :ivar massnahme:
    :ivar feldinhalt:
    :ivar datenfeld: Standardfehlermeldung, die dem gesamten Request
        zuzuordnen sind.
    :ivar quelle: Für Fehlermeldungen, die bei Massendatenübermittlung
        bestimmten Einzelelementen durch BE/Matrikel/Semester zuzuordnen
        sind.
    :ivar fehlerquelle: Für Elemente, die bei Massendatenübermittlung
        durch BE/Matrikel/Semster + Studienbild zuzuordnen sind.
    :ivar fehlerref: Für Fehlermeldungen, die nicht via Studierendenkey
        (BE/Matrikel/Semester) zuordenbar sind.
    """
    class Meta:
        name = "fehler"

    fehlernummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    kategorie: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    fehlertext: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    massnahme: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    feldinhalt: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    datenfeld: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    quelle: Optional[Studierendenkey] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    fehlerquelle: Optional[Fehlerquelle] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    fehlerref: Optional[Fehlerref] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Kandidat:
    class Meta:
        name = "kandidat"

    ekz_basisdaten: Optional[EkzBasisdaten] = field(
        default=None,
        metadata={
            "name": "ekzBasisdaten",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    ekz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "white_space": "collapse",
        }
    )


@dataclass
class Matrikelkorrekturanfrage(UniStudentAnfrage):
    class Meta:
        name = "matrikelkorrekturanfrage"

    matrikelalt: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-6][0-9]{7}",
        }
    )


@dataclass
class MitbelegungAbschluss(Datensatz):
    class Meta:
        name = "mitbelegungAbschluss"


@dataclass
class MitbelegungStudien(Datensatz):
    class Meta:
        name = "mitbelegungStudien"


@dataclass
class MitbelegungStudierende(Datensatz):
    class Meta:
        name = "mitbelegungStudierende"


@dataclass
class MobilitaetFh(MobilitaetVonBis):
    """
    :ivar zweck:
    :ivar ectserworben:
    :ivar ectsangerechnet:
    :ivar aufenthaltfoerderungcode:
    :ivar herkunftslandcode: Pflichtfeld ab API 0.7!
    :ivar partnercode: Entfaellt ab API 0.7. 'herkunftslandcode'
        verwenden!
    :ivar id: Pflichtfeld ab API 0.8!
    """
    class Meta:
        name = "mobilitaetFH"

    zweck: List[MobiZweckTyp] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
            "max_occurs": 4,
        }
    )
    ectserworben: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_inclusive": "0",
            "max_inclusive": "250",
            "total_digits": 3,
            "fraction_digits": 1,
            "white_space": "collapse",
            "pattern": r"^[0-9]{1,3}(|[,.][0-9]{1})$",
        }
    )
    ectsangerechnet: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_inclusive": "0",
            "max_inclusive": "250",
            "total_digits": 3,
            "fraction_digits": 1,
            "white_space": "collapse",
            "pattern": r"^[0-9]{1,3}(|[,.][0-9]{1})$",
        }
    )
    aufenthaltfoerderungcode: List[MobilitaetFhAufenthaltfoerderungcode] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "max_occurs": 5,
        }
    )
    herkunftslandcode: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_length": 1,
            "max_length": 3,
            "pattern": r"[A-Z ]{1,3}",
        }
    )
    partnercode: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_inclusive": 0,
            "max_inclusive": 99999,
        }
    )
    id: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_length": 1,
            "max_length": 150,
            "white_space": "collapse",
            "pattern": r"[A-Za-z0-9][A-Za-z0-9.\-_]{0,149}",
        }
    )


@dataclass
class Nachweisliste:
    class Meta:
        name = "nachweisliste"

    nachweis: List[Nachweis] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
        }
    )


@dataclass
class Personliste:
    class Meta:
        name = "personliste"

    personen: List[Person] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Pruefungen:
    class Meta:
        name = "pruefungen"

    pruefung: List[Pruefung] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "max_occurs": 2,
        }
    )


@dataclass
class Refundierungsanfrage(UniStudentAnfrage):
    class Meta:
        name = "refundierungsanfrage"

    refundierungsbetrag: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_inclusive": 1,
            "max_inclusive": 999999,
        }
    )
    bearbeitungsname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    referenznummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[\p{L}\p{N}\p{P}\s\+]{3,255}",
        }
    )


@dataclass
class SimplePersonInfo:
    class Meta:
        name = "simplePersonInfo"

    person: Optional[SimplePhysicalPerson] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    adresse: Optional[ClearingAdresse] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class StudentInfoBasis(StudentInfoMinimal):
    class Meta:
        name = "studentInfoBasis"

    staatsbuergerschaft: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_length": 1,
            "max_length": 3,
            "pattern": r"[A-Z ]{1,3}",
        }
    )
    akadgrad: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[A-Za-z.\-/,'´`() À-ž&]{0,255}",
        }
    )
    akadnach: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[A-Za-z.\-/,'´`() À-ž&]{0,255}",
        }
    )


@dataclass
class Studienberechtigungliste:
    class Meta:
        name = "studienberechtigungliste"

    studienberechtigung: List[Studienberechtigung] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
        }
    )


@dataclass
class StudienberechtigunglisteFh:
    class Meta:
        name = "studienberechtigunglisteFH"

    studienberechtigung: List[StudienberechtigungFh] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
        }
    )


@dataclass
class Studienloeschanfrage(UniStudentAnfrage):
    class Meta:
        name = "studienloeschanfrage"

    studienkennung: Optional[Studienkennung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class Studiumabschluss:
    class Meta:
        name = "studiumabschluss"

    studienkennung: Optional[Studienkennung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studierendenkey: Optional[Studierendenkey] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    abschluesse: Optional[Abschluesse] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class Zahlungsanfrage(UniStudentAnfrage):
    class Meta:
        name = "zahlungsanfrage"

    zahlungsart: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "min_inclusive": 1,
            "max_inclusive": 2,
        }
    )
    betrag: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    buchungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    referenznummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class KontostandListe:
    kontostand: List[Kontostand] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class KontostandUniInfo(Kontostand):
    statusbefreit: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    vorschreibung: Optional[Vorschreibung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class Matrikelpruefergebnis:
    statuscode: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    statusmeldung: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    matrikelliste: Optional[MatrikelListe] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class NachweisAntwortListe(Nachweisliste):
    uuid: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"NULL|[0-9|a-f|A-F]{8}-[0-9|a-f|A-F]{4}-[0-9|a-f|A-F]{4}-[0-9|a-f|A-F]{4}-[0-9|a-f|A-F]{12}",
        }
    )


@dataclass
class StudentInfoBpk(StudentInfoBasis):
    class Meta:
        name = "StudentInfoBPK"

    geburtsland: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    alternativname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    adresse: Optional[Adresse] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class StudiumMeldungFh:
    """
    :ivar stgkz:
    :ivar ausbildungssemester: HINWEIS: Das Bezugsstemester erwartet der
        Datenverbund im studierendenkey!!!
    :ivar berufstaetigkeitcode:
    :ivar perskz:
    :ivar studstatuscode:
    :ivar meldestatus: Optional ab AIP 0.6, verpflichtend in API 0.7!
        I=Inländer, A=Ausländer, U=Unterbrecher, O=Storno, BLANK=nicht
        fortgesetzt.
    :ivar standortcode:
    :ivar zulassungsdatum:
    :ivar beendigungsdatum:
    :ivar zugangsberechtigung:
    :ivar zugangsberechtigung_ma:
    :ivar studstatuscodestichtag:
    :ivar beendigungsdatumstichtag:
    :ivar meldestatusstichtag: Meldestatus zum aktuellen BIS-Stichtag.
        Falls das Element fehlt, wird der Wert von meldestatus der
        letzten Meldung vor dem Stichtag angenommen.
    :ivar gemeinsam: Nicht zulässig, wenn disloziert=J
    :ivar orgformcode:
    :ivar mobilitaet: Nicht zulässig, wenn disloziert=J
    :ivar bmwfwfoerderrelevant:
    :ivar vornachperskz:
    :ivar mobilitaetsprogrammcode:
    :ivar wiedereintrittsdatum:
    :ivar unterbrechungsdatum:
    :ivar wiedereintrittsdatumstichtag:
    :ivar unterbrechungsdatumstichtag:
    :ivar dualesstudium:
    :ivar disloziert:
    """
    class Meta:
        name = "StudiumMeldungFH"

    stgkz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"\d{7}",
        }
    )
    ausbildungssemester: Optional[StudiumMeldungFhAusbildungssemester] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    berufstaetigkeitcode: Optional[StudiumMeldungFhBerufstaetigkeitcode] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    perskz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"\d{10}",
        }
    )
    studstatuscode: Optional[StudiumMeldungFhStudstatuscode] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    meldestatus: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "white_space": "preserve",
            "pattern": r"[ IUAO]",
        }
    )
    standortcode: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    zulassungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    beendigungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    zugangsberechtigung: Optional[Zugangsberechtigung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    zugangsberechtigung_ma: Optional[Zugangsberechtigung] = field(
        default=None,
        metadata={
            "name": "zugangsberechtigungMA",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studstatuscodestichtag: Optional[int] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    beendigungsdatumstichtag: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    meldestatusstichtag: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "white_space": "preserve",
            "pattern": r"[ IUAO]",
        }
    )
    gemeinsam: List[GemeinsamTyp] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    orgformcode: Optional[OrgformTyp] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    mobilitaet: List[MobilitaetFh] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    bmwfwfoerderrelevant: Optional[JaNeinStr] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    vornachperskz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"\d{10}",
        }
    )
    mobilitaetsprogrammcode: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    wiedereintrittsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    unterbrechungsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    wiedereintrittsdatumstichtag: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    unterbrechungsdatumstichtag: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    dualesstudium: Optional[JaNeinStr] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    disloziert: JaNeinStr = field(
        default=JaNeinStr.N_1,
        metadata={
            "type": "Attribute",
        }
    )


@dataclass
class Fehlerliste:
    class Meta:
        name = "fehlerliste"

    fehler: List[Fehler] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    fehleranzahl: int = field(
        default=0,
        metadata={
            "type": "Attribute",
        }
    )


@dataclass
class Kandidaten:
    class Meta:
        name = "kandidaten"

    kandidat: List[Kandidat] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class MatrikelClearingMeldung:
    class Meta:
        name = "matrikel-clearing-meldung"
        namespace = "http://www.brz.gv.at/datenverbund-unis"

    uuid: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
            "pattern": r"NULL|[0-9|a-f|A-F]{8}-[0-9|a-f|A-F]{4}-[0-9|a-f|A-F]{4}-[0-9|a-f|A-F]{4}-[0-9|a-f|A-F]{12}",
        }
    )
    meldeuni: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
            "min_length": 2,
            "max_length": 2,
            "pattern": r"[UPFR][A-Z]",
        }
    )
    meldedatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )
    studierende: Optional[Personliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )


@dataclass
class StudentInfoExtended(StudentInfoBasis):
    class Meta:
        name = "studentInfoExtended"

    bpk: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"([A-Za-z0-9+/]{27})=",
        }
    )
    svnr: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"\d{10}",
        }
    )
    ekz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[A-Z]{4}[0-9]{6}",
        }
    )


@dataclass
class Studienberechtigunganfrage(AbstractAnfrage):
    class Meta:
        name = "studienberechtigunganfrage"

    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[UPFR][A-Z]",
        }
    )
    studienberechtigungliste_fh: Optional[StudienberechtigunglisteFh] = field(
        default=None,
        metadata={
            "name": "studienberechtigunglisteFH",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studienberechtigungliste: Optional[Studienberechtigungliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Studium(StudiumMeldung):
    class Meta:
        name = "studium"

    abschluesse: Optional[Abschluesse] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    pruefungen: Optional[Pruefungen] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Studiumabschluesse:
    class Meta:
        name = "studiumabschluesse"

    studiumabschluss: List[Studiumabschluss] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
        }
    )


@dataclass
class Studiumpruefung:
    """
    :ivar studierendenkey:
    :ivar studienkennung: UNI/PH verwenden "studienkennung".
    :ivar studiengang: FH verwenden "studiengang".
    :ivar pruefungen:
    """
    class Meta:
        name = "studiumpruefung"

    studierendenkey: Optional[Studierendenkey] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    studienkennung: Optional[Studienkennung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studiengang: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"\d{7}",
        }
    )
    pruefungen: Optional[Pruefungen] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class FehlerAnfrage(AbstractAnfrage):
    fehlerliste: Optional[Fehlerliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class GesamtStudentInfo(StudentInfoExtended):
    matrikelnummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    matrikelstatus: Optional[Matrikelstatus] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    maturadatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class StudentInfoKonto(StudentInfoHuelle):
    studienbeitrag: Optional[KontostandUniInfo] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class StudienDaten:
    """Liste von Studien ohne Prüfungsdaten.

    Verwende diese Variante bei der Meldung neuer Studiendaten oder wenn
    die zugehörigen Prüfungen und Abschlüsse bereits in einem anderen
    Element dargestellt werden.

    :ivar studium: UNI/PH müssen diese Variante verwenden!
    :ivar studiengang:
    :ivar lehrgang:
    """
    studium: List[StudiumMeldung] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studiengang: List[StudiumMeldungFh] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    lehrgang: List[LehrgangMeldungFh] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Abschlussanfrage(AbstractAnfrage):
    class Meta:
        name = "abschlussanfrage"

    studiumabschluesse: Optional[Studiumabschluesse] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class AbstractAntwort:
    class Meta:
        name = "abstractAntwort"

    uuid: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    fehlerliste: Optional[Fehlerliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class EkzAnforderung:
    class Meta:
        name = "ekzAnforderung"

    ekz_basis: Optional[EkzBasisdaten] = field(
        default=None,
        metadata={
            "name": "ekzBasis",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    ekz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "white_space": "collapse",
        }
    )
    kandidaten: Optional[Kandidaten] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    returncode: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    returntext: Optional[Returntext] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    forcierungskey: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Kennzahlenantwort:
    class Meta:
        name = "kennzahlenantwort"

    uuid: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    fehlerliste: Optional[Fehlerliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    kennzahlenliste: Optional[Kennzahlenliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class StudentInfoBasisAdressen(StudentInfoExtended):
    class Meta:
        name = "studentInfoBasisAdressen"

    adressen: Optional[AdressenListe] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class Studienliste:
    """Liste von Studien inklusive Prüfungen und Abschlüsse.

    Verwende diese Variante für Responses, nicht aber für Request-
    Elemente, da hier die Prüfungen und Abschlüsse getrennt zu melden
    sind.
    """
    class Meta:
        name = "studienliste"

    studium: List[Studium] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studiengang: List[StudiumMeldungFh] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    lehrgang: List[LehrgangMeldungFh] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Studierendefehlerliste:
    class Meta:
        name = "studierendefehlerliste"

    studierendenkey: Optional[Studierendenkey] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    fehlerliste: Optional[Fehlerliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class Studiumpruefungen:
    class Meta:
        name = "studiumpruefungen"

    studiumpruefung: List[Studiumpruefung] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Bpkantwort(AbstractAntwort):
    class Meta:
        name = "BPKAntwort"

    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    semester: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    datenstand: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    bpk: List[BpkantwortSatz] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class FehlerAntwort(AbstractAntwort):
    pass


@dataclass
class GesamtStudentInfos:
    gesamtstudentinfo: List[GesamtStudentInfo] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class MatrikelnummernMeldungAntwort(AbstractAntwort):
    pass


@dataclass
class NachweisAntwort(AbstractAntwort):
    pass


@dataclass
class StudentInfoBla(GesamtStudentInfo):
    studienbeitrag: Optional[KontostandUniInfo] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class UniStudentInfo(StudentInfoBasisAdressen):
    studierendenkey: Optional[Studierendenkey] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class Abschlussantwort(AbstractAntwort):
    class Meta:
        name = "abschlussantwort"

    studiumabschluesse: Optional[Studiumabschluesse] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Batch2Restanfrage:
    class Meta:
        name = "batch2restanfrage"

    dispatch_key: Optional[str] = field(
        default=None,
        metadata={
            "name": "dispatchKey",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    abstractanfrage: Optional[AbstractAnfrage] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    link: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    httpmethod: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    abstractantwort: Optional[AbstractAntwort] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class EkzAntwort(AbstractAntwort):
    class Meta:
        name = "ekzAntwort"

    ekz_anforderung: List[EkzAnforderung] = field(
        default_factory=list,
        metadata={
            "name": "ekzAnforderung",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    ekz_forcierung: List[EkzForcierung] = field(
        default_factory=list,
        metadata={
            "name": "ekzForcierung",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    rueckgabewert: Optional[Rueckgabewert] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    response_timestamp: Optional[str] = field(
        default=None,
        metadata={
            "name": "responseTimestamp",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"\d{4}-\d{2}-\d{2}[T -]\d{2}:\d{2}:\d{2}([,.]\d{1,9})?([+-]\d{2}([:][0-5]\d)?)?",
        }
    )


@dataclass
class EkzUseCase:
    class Meta:
        name = "ekzUseCase"
        namespace = "http://www.brz.gv.at/datenverbund-unis"

    ekz_anforderung: List[EkzAnforderung] = field(
        default_factory=list,
        metadata={
            "name": "ekzAnforderung",
            "type": "Element",
        }
    )
    ekz_forcierung: List[EkzForcierung] = field(
        default_factory=list,
        metadata={
            "name": "ekzForcierung",
            "type": "Element",
        }
    )


@dataclass
class Kontostandantwort(AbstractAntwort):
    class Meta:
        name = "kontostandantwort"

    kontostandliste: Optional[KontostandListe] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class MatrikelClearingAntwort(AbstractAntwort):
    class Meta:
        name = "matrikel-clearing-antwort"
        namespace = "http://www.brz.gv.at/datenverbund-unis"

    meldeuni: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
            "min_length": 2,
            "max_length": 2,
            "pattern": r"[UPFR][A-Z]",
        }
    )
    meldedatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )
    studierende: Optional[Personliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )


@dataclass
class Matrikelkorrekturantwort(AbstractAntwort):
    class Meta:
        name = "matrikelkorrekturantwort"


@dataclass
class Matrikelnummernantwort(AbstractAntwort):
    class Meta:
        name = "matrikelnummernantwort"

    matrikelnummernliste: Optional[Matrikelnummernliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Matrikelpruefungantwort(AbstractAntwort):
    class Meta:
        name = "matrikelpruefungantwort"

    matrikelpruefergebnis: Optional[Matrikelpruefergebnis] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class MitbelegungAntwort(AbstractAntwort):
    class Meta:
        name = "mitbelegungAntwort"

    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    semester: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    datenstand: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    student: List[MitbelegungStudierende] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studium: List[MitbelegungStudien] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    pruefung: List[MitbelegungAbschluss] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Pruefungsaktivitaetenanfrage(AbstractAnfrage):
    class Meta:
        name = "pruefungsaktivitaetenanfrage"

    studiumpruefungen: Optional[Studiumpruefungen] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class Pruefungsaktivitaetenantwort(AbstractAntwort):
    class Meta:
        name = "pruefungsaktivitaetenantwort"

    studiumpruefungen: Optional[Studiumpruefungen] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Refundierungsantwort(AbstractAntwort):
    class Meta:
        name = "refundierungsantwort"

    refundierungsmeldung: List[Refundierungsmeldung] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class StammdatenAntwort(AbstractAntwort):
    class Meta:
        name = "stammdatenAntwort"


@dataclass
class StudentInfo(StudentInfoBasisAdressen):
    """
    :ivar beitragstatus: Ist auch für FH notwendig: "X" (ÖH-Beitrag +
        FH-Studienbeitrag), "O" (Buchstabe O = Ohne ÖH-Beitragspflicht),
        "0" (Ziffer 0 = Mitbeleger).
    :ivar zaehlung_pe_pn:
    :ivar zaehlung_po:
    :ivar emailliste:
    :ivar emailadressen: Element 'emailadressen' ist veraltet und wird
        in der nächsten API-Version entfernt. Bitte ausschließlich
        Element 'emailliste' verwenden!!!
    """
    class Meta:
        name = "studentInfo"

    beitragstatus: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[ABCEFGHIJLMNOQRSUVWXZ0]",
        }
    )
    zaehlung_pe_pn: Optional[StudentInfoZaehlungPePn] = field(
        default=None,
        metadata={
            "name": "zaehlungPePn",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    zaehlung_po: Optional[StudentInfoZaehlungPo] = field(
        default=None,
        metadata={
            "name": "zaehlungPo",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    emailliste: Optional[EmailListe] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    emailadressen: Optional[EmailadressenListe] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class StudentInfoMitbelegung(StudentInfoHuelle):
    class Meta:
        name = "studentInfoMitbelegung"

    vorname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_length": 1,
            "max_length": 255,
        }
    )
    nachname: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_length": 1,
            "max_length": 255,
        }
    )
    geburtsdatum: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    geschlecht: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[MWXOIK]",
        }
    )
    staatsbuergerschaft: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_length": 1,
            "max_length": 3,
            "pattern": r"[A-Z ]{1,3}",
        }
    )
    akadgrad: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[A-Za-z.\-/,'´`() À-ž&]{0,255}",
        }
    )
    akadnach: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[A-Za-z.\-/,'´`() À-ž&]{0,255}",
        }
    )
    beitragstatus: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[ABCEFGHIJLMNOQRSUVWXZ0]",
        }
    )
    zaehlung_pe_pn: Optional[StudentInfoMitbelegungZaehlungPePn] = field(
        default=None,
        metadata={
            "name": "zaehlungPePn",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    zaehlung_po: Optional[StudentInfoMitbelegungZaehlungPo] = field(
        default=None,
        metadata={
            "name": "zaehlungPo",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    bpk: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"([A-Za-z0-9+/]{27})=",
        }
    )
    svnr: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"\d{10}",
        }
    )
    ekz: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[A-Z]{4}[0-9]{6}",
        }
    )
    adressen: Optional[AdressenListe] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    emailliste: Optional[EmailListe] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    matrikelnummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    studienliste: Optional[Studienliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Studienanfrage(UniStudentAnfrage):
    class Meta:
        name = "studienanfrage"

    studien: Optional[StudienDaten] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class Studienantwort(AbstractAntwort):
    class Meta:
        name = "studienantwort"

    studienliste: Optional[Studienliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Studienberechtigungantwort(AbstractAntwort):
    class Meta:
        name = "studienberechtigungantwort"


@dataclass
class Studienloeschantwort(AbstractAntwort):
    class Meta:
        name = "studienloeschantwort"


@dataclass
class Studierendefehlerlisten:
    class Meta:
        name = "studierendefehlerlisten"

    studierendefehlerliste: List[Studierendefehlerliste] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class ZulassungsantragAntwort(AbstractAntwort):
    class Meta:
        name = "zulassungsantragAntwort"


@dataclass
class FullStudentInfo(UniStudentInfo):
    studienliste: Optional[Studienliste] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studienbeitrag: Optional[KontostandUniInfo] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Stammdaten(UniStudentInfo):
    """
    Reiner Alias für UniStudentInfo zur besseren Verständlichkeit.
    """


@dataclass
class Batch2Restanfragen:
    class Meta:
        name = "batch2restanfragen"
        namespace = "http://www.brz.gv.at/datenverbund-unis"

    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
            "pattern": r"[UPFR][A-Z]",
        }
    )
    datenstand: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )
    batch2restanfrage: List[Batch2Restanfrage] = field(
        default_factory=list,
        metadata={
            "type": "Element",
        }
    )


@dataclass
class MitbelegungAntwortV2(AbstractAntwort):
    class Meta:
        name = "mitbelegungAntwortV2"

    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    semester: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    datenstand: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    student_info: List[StudentInfoMitbelegung] = field(
        default_factory=list,
        metadata={
            "name": "studentInfo",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class SimpleBpkResponse:
    """
    :ivar personenkennzeichen: Element 'personenkennzeichen' ist
        veraltet und wird in der nächsten API-Version entfernt. Bitte
        ausschließlich Element 'bpk' verwenden!!!
    :ivar bpk:
    :ivar person_info:
    :ivar fehler_antwort:
    """
    class Meta:
        name = "simpleBpkResponse"

    personenkennzeichen: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    bpk: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "pattern": r"([A-Za-z0-9+/]{27})=",
        }
    )
    person_info: List[SimplePersonInfo] = field(
        default_factory=list,
        metadata={
            "name": "personInfo",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "max_occurs": 5,
        }
    )
    fehler_antwort: Optional[FehlerAntwort] = field(
        default=None,
        metadata={
            "name": "fehlerAntwort",
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )


@dataclass
class Stammdatenanfrage(UniStudentAnfrage):
    class Meta:
        name = "stammdatenanfrage"
        namespace = "http://www.brz.gv.at/datenverbund-unis"

    stammdaten: Optional[StudentInfo] = field(
        default=None,
        metadata={
            "type": "Element",
        }
    )
    vorschreibung: Optional[Vorschreibung] = field(
        default=None,
        metadata={
            "type": "Element",
        }
    )


@dataclass
class StudentBlockAnfrage:
    class Meta:
        name = "studentBlockAnfrage"

    matrikelnummer: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-6][0-9]{7}",
        }
    )
    stammdaten: Optional[StudentInfo] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    vorschreibung: Optional[Vorschreibung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class Studierendefehlerantwort(AbstractAntwort):
    class Meta:
        name = "studierendefehlerantwort"

    studierendefehlerlisten: Optional[Studierendefehlerlisten] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class ZulassungsantragAnfrage(UniSemesterAnfrage):
    class Meta:
        name = "zulassungsantragAnfrage"

    studierende: Optional[StudentInfoMitbelegung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    vorschreibung: Optional[Vorschreibung] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class RootForDotNet:
    """Trigger-Element zur Generierung von C#/.NET Model-Klassen.

    Wird im API selbst nicht verwendet.
    """
    class Meta:
        namespace = "http://www.brz.gv.at/datenverbund-unis"

    mitbelegungen: Optional[MitbelegungAntwort] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )
    simple_bpk_response: Optional[SimpleBpkResponse] = field(
        default=None,
        metadata={
            "name": "simpleBpkResponse",
            "type": "Element",
            "required": True,
        }
    )
    mitbeleger: Optional[MitbelegungAntwortV2] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )
    matrikelnummernmeldungantwort: Optional[MatrikelnummernMeldungAntwort] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )
    matrikelnummernanfrage: Optional[MatrikelReservierenAnfrage] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )
    matrikelnummernantwort: Optional[Matrikelnummernantwort] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )
    matrikelnummernmeldung: Optional[MatrikelMeldungAnfrage] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )
    nachweisliste: Optional[NachweisAntwortListe] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )
    kennzahlenantwort: Optional[Kennzahlenantwort] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        }
    )


@dataclass
class StudentStudiumInfo(StudentBlockAnfrage):
    datenstand: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    bezahlt: Optional[KontostandBasis] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studien: Optional[StudienDaten] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studiumpruefungen: Optional[Studiumpruefungen] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    studiumabschluesse: Optional[Studiumabschluesse] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class UniStudentInfos:
    unistudentinfo: List[FullStudentInfo] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class StammdatenblockAnfrage(AbstractAnfrage):
    class Meta:
        name = "stammdatenblockAnfrage"

    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[UPFR][A-Z]",
        }
    )
    semester: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-9]{4}[SW]",
        }
    )
    student: List[StudentBlockAnfrage] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
        }
    )


@dataclass
class Student(StudentBlockAnfrage):
    class Meta:
        name = "student"
        namespace = "http://www.brz.gv.at/datenverbund-unis"


@dataclass
class Fullstudentantwort(AbstractAntwort):
    class Meta:
        name = "fullstudentantwort"

    unistudentinfos: Optional[UniStudentInfos] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )
    gesamtstudentinfos: Optional[GesamtStudentInfos] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
        }
    )


@dataclass
class StammdatenblockAntwort(AbstractAnfrage):
    class Meta:
        name = "stammdatenblockAntwort"

    be: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[UPFR][A-Z]",
        }
    )
    semester: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
            "pattern": r"[0-9]{4}[SW]",
        }
    )
    datenstand: Optional[XmlDate] = field(
        default=None,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "required": True,
        }
    )
    student: List[StudentStudiumInfo] = field(
        default_factory=list,
        metadata={
            "type": "Element",
            "namespace": "http://www.brz.gv.at/datenverbund-unis",
            "min_occurs": 1,
        }
    )
