import React from "react";
import { render, screen, cleanup } from "@testing-library/react";
import App from "../App";

afterEach(cleanup);
describe("basic app tests", () => {
  test("renders learn react link", () => {
    const { queryByText } = render(<App />);
    const linkElement = queryByText(/Pokmon App/i);
    expect(linkElement).toBeNull();
  });

  test("renders learn react link", () => {
    const { getByText } = render(<App />);
    const linkElement = getByText(/Pokemon App/i);
    expect(linkElement).toBeInTheDocument();
  });

  test("test button with role", () => {
    render(<App />);

    // getByRole gets element either by implicit roles or
    // by aria-label attributes.  It will also suggest some roles
    // which can be used if the one provided does not match any in your dom tree
    expect(screen.getByRole("button")).toHaveTextContent("Fetch Pokemons");
    // screen.debug();
  });

  test("test button with data id", () => {
    render(<App />);

    // get element by data-testid
    expect(screen.getByTestId("button")).toHaveTextContent("Fetch Pokemons");
    // screen.debug();
  });

  test("test button with role", () => {
    render(<App />);
    expect(screen.queryByText("Fetch pokmons")).toBeNull();
  });

  test("test button with text", () => {
    render(<App />);

    // get element by it's text content
    expect(screen.getByText("Fetch Pokemons")).toHaveTextContent(
      "Fetch Pokemons"
    );
    // screen.debug();
  });
});
