import React from "react";
import App from "./App";
import { render, waitFor } from "@testing-library/react";

describe("<App />", () => {
  it("should render the loading fallback", () => {
    const { container } = render(<App />);
    expect(container.textContent).toContain('Loading...');
  });

  it("should route and render the home page", async () => {
    const { debug, container } = render(<App />);
    expect(container.textContent).toContain('Loading...');

    await waitFor(() => {
      expect(container.textContent).toContain('Home Page');
      debug();
    });
  });
});
