# How to run and close a Task using the V5 Challenge API

## Endpoints

- Base API URL: `https://api.topcoder-dev.com/v5`
- Challenges API: `/challenges`
- Resources API: `/resources`

### Creating the Task

- In order to create the Task, execure the following cURL

```
curl --location --request POST 'https://api.topcoder-dev.com/v5/challenges' \
--header 'Authorization: Bearer <token>' \
--header 'Content-Type: application/json' \
--data-raw '{
  "status": "Draft",
  "trackId": "9b6fc876-f4d9-4ccb-9dfd-419247628825",
  "typeId": "ecd58c69-238f-43a4-a4bb-d172719b9f31",
  "legacy": {
    "reviewType": "COMMUNITY"
  },
  "name": "E2E test for closing out a task - Thomas",
  "description": "description",
  "projectId": 9171,
  "timelineTemplateId": "53a307ce-b4b3-4d6f-b9a1-3741a58f77e6",
  "phases": [
    {
      "phaseId": "6950164f-3c5e-4bdc-abc8-22aaf5a1bd49",
      "duration": 86400
    },
    {
      "phaseId": "003a4b14-de5d-43fc-9e35-835dbeb6af1f",
      "duration": 86400
    },
    {
      "phaseId": "ad985cff-ad3e-44de-b54e-3992505ba0ae",
      "duration": 86400
    }
  ],
  "startDate": "2020-09-18T05:10:35Z",
  "prizeSets": [
    {
      "prizes": [
        {
          "type": "USD",
          "value": 1
        }
      ],
      "description": "Challenge Prizes",
      "type": "placement"
    }
  ],
  "tags": [
    "Heroku"
  ]
}'
```

- This will create a `Develop` - `Task` with status `Draft`.

### Activating the task

- To activate the challenge, simply run the following cURL:

```
curl --location --request PATCH 'https://api.topcoder-dev.com/v5/challenges/{{CHALLENGE_ID}}' \
--header 'Authorization: Bearer <token>' \
--header 'Content-Type: application/json' \
--data-raw '{
    "status": "Active",
    "phases": [
        {
            "duration": 864265,
            "scheduledEndDate": "2020-09-28T05:14:00Z",
            "actualEndDate": "2020-09-18T19:54:27Z",
            "isOpen": true,
            "name": "Registration",
            "phaseId": "a93544bc-c165-4af4-b55e-18f3593b457a",
            "actualStartDate": "2020-09-18T19:54:27Z",
            "id": "0b3fa63f-7aa5-4ae8-8cfa-344a66253f1e",
            "scheduledStartDate": "2020-09-18T05:10:35Z"
        },
        {
            "duration": 86400,
            "scheduledEndDate": "2020-09-19T05:15:00Z",
            "actualEndDate": "2020-09-18T19:54:27Z",
            "isOpen": false,
            "name": "Iterative Review",
            "phaseId": "003a4b14-de5d-43fc-9e35-835dbeb6af1f",
            "actualStartDate": "2020-09-18T19:54:27Z",
            "id": "73641825-e1e4-4e60-a1e7-9ab88acb9a19",
            "scheduledStartDate": "2020-09-18T05:15:00Z"
        },
        {
            "duration": 864000,
            "scheduledEndDate": "2020-09-28T05:15:00Z",
            "actualEndDate": "2020-09-18T19:54:27Z",
            "isOpen": false,
            "name": "Submission",
            "phaseId": "6950164f-3c5e-4bdc-abc8-22aaf5a1bd49",
            "actualStartDate": "2020-09-18T19:54:27Z",
            "id": "5f63dc27-67fd-4765-8878-8fe4d71ee17a",
            "scheduledStartDate": "2020-09-18T05:15:00Z"
        }
    ]
}'
```

- This will set the status to active and open the registration phase.

> **You have to wait until the challenge gets created on legacy before you are able to activate it.** The API will not let you activate the challenge until it gets created on legacy.

### Assigning the member to the `Task`

- To assign a Task to a member, you simply need to create a resource with the role `Submitter` for that user/challenge combination. To do so, run the following cURL:

```
curl --location --request POST 'https://api.topcoder-dev.com/v5/resources' \
--header 'Authorization: Bearer <token>' \
--header 'Content-Type: application/json' \
--data-raw '{
    "challengeId": "{{CHALLENGE_ID}}",
    "memberHandle": "TonyJ",
    "roleId": "732339e7-8e30-49d7-9198-cccf9451e221"
}'
```

- Set the `challengeId` to the `id` of the challenge you created earlier.
- Set the `memberHandle` to the username of the assignee.
- Set the `roleId` to the `id` from the `Submitter` `ResourceRole` (you can see the available resource roles by calling the http://api.topcoder-dev.com/v5/resource-roles API)

### Close out the `Task`

- To close a `Task` as `Completed`, run the following cURL:

```
curl --location --request PATCH 'https://api.topcoder-dev.com/v5/challenges/{{CHALLENGE_ID}}' \
--header 'Authorization: Bearer <token>' \
--header 'Content-Type: application/json' \
--data-raw '{
    "status": "Completed",
    "winners": [
        {
            "userId": 8547899,
            "handle": "TonyJ",
            "placement": 1
        }
    ]
}'
```

- The `legacy-challenge-processor` will pick up the event and also close the task on legacy.
