import grpc
import route_guide_pb2 as route_guide_pb2
import route_guide_pb2_grpc as route_guide_pb2_grpc

ip = '127.0.0.1'
rectangle = route_guide_pb2.Rectangle()

rectangle.lo.longitude = -750000000
rectangle.lo.latitude = 400000000
rectangle.hi.longitude = -730000000
rectangle.hi.latitude = 420000000

with grpc.insecure_channel("localhost:31415") as channel:
    stub = route_guide_pb2_grpc.RouteGuideStub(channel)
    for feature in stub.ListFeatures(rectangle):
        print(f"Got feature '{feature.name}' at ({feature.location.latitude}, {feature.location.longitude})")
