﻿using Microsoft.Maui.Controls;

namespace HeaderFooterShellFlyoutSample;
 
public class HeaderFooterShellFlyout : Shell
{
    public HeaderFooterShellFlyout()
    {
        // Create a Flyout Item with a content page
        var mainPage = new ContentPage
        {
            Title = "Flyout Item",
            Content = new StackLayout
            {
                Children =
                {
                    new Label
                    {
                        Text = "Open the Flyout and Toggle the Header and Footer. If it changes after each click test has passed.",
                        AutomationId = "PageLoaded"
                    }
                }
            }
        };

        Items.Add(new FlyoutItem
        {
            Title = "Main Page",
            Items = { new ShellContent { Content = mainPage } }
        });

        // Add Toggle Header/Footer Template Menu
        Items.Add(new MenuItem
        {
            Text = "Toggle Header/Footer Template",
            Command = new Command(() =>
            { 

                if (FlyoutHeaderTemplate == null)
                {
                    FlyoutHeaderTemplate = new DataTemplate(() => new Label { Text = "Header Template" });
                    FlyoutFooterTemplate = new DataTemplate(() => new Label { Text = "Footer Template" });
                }
                else
                {
                    FlyoutHeaderTemplate = null;
                    FlyoutFooterTemplate = null;
                }
            }),
            AutomationId = "ToggleHeaderFooterTemplate"
        });

        // Add Toggle Header/Footer View Menu
        Items.Add(new MenuItem
        {
            Text = "Toggle Header/Footer View",
            Command = new Command(() =>
            {
                

                if (FlyoutHeader != null)
                {
                    FlyoutHeader = null;
                    FlyoutFooter = null;
                }
                else
                {
                    FlyoutHeader = new StackLayout
                    {
                        Children = { new Label { Text = "Header" } },
                        AutomationId = "Header1View"
                    };

                    FlyoutFooter = new StackLayout
                    {
                        Orientation = StackOrientation.Horizontal,
                        Children = { new Label { Text = "Footer" } },
                        AutomationId = "Footer1View"
                    };
                }
            }),
            AutomationId = "ToggleHeaderFooter"
        });

        // Add Resize Header/Footer Menu
        Items.Add(new MenuItem
        {
            Text = "Resize Header/Footer",
            Command = new Command(async () =>
            {
                

                FlyoutHeaderTemplate = null;
                FlyoutFooterTemplate = null;

                if (FlyoutHeader == null)
                {
                    FlyoutHeader = new StackLayout
                    {
                        Children = { new Label { Text = "Header" } },
                        AutomationId = "HeaderView"
                    };

                    FlyoutFooter = new StackLayout
                    {
                        Children = { new Label { Text = "Footer" } },
                        AutomationId = "FooterView"
                    };

                    await Task.Delay(10);
                }

                var headerLabel = (VisualElement)FlyoutHeader;
                var footerLabel = (VisualElement)FlyoutFooter;

                headerLabel.BackgroundColor = Colors.LightBlue;
                if (footerLabel is not null)
                    footerLabel.BackgroundColor = Colors.LightCoral;

                if (headerLabel.HeightRequest == 60)
                {
                    headerLabel.HeightRequest = 200;
                    if (footerLabel is not null)
                        footerLabel.HeightRequest = 200;
                }
                else
                {
                    headerLabel.HeightRequest = 60;
                    if (footerLabel is not null)
                        footerLabel.HeightRequest = 60;
                }
            }),
            AutomationId = "ResizeHeaderFooter"
        });

        // Add Zero Margin Header Test Menu for iOS
        if (DeviceInfo.Platform == DevicePlatform.iOS)
        {
            Items.Add(new MenuItem
            {
                Text = "Zero Margin Header Test",
                Command = new Command(() =>
                {
                    FlyoutHeader = new StackLayout
                    {
                        AutomationId = "ZeroMarginLayout",
                        Margin = 0,
                        Children = { new Label { Text = "Header View" } },
                        BackgroundColor = Colors.Purple
                    };

                    FlyoutHeaderTemplate = null;
                    FlyoutBehavior = FlyoutBehavior.Locked;
                }),
                AutomationId = "ZeroMarginHeader"
            });
        }
    }
}
