
use super::super::reading_history;
use sea_orm::{ConnectionTrait, EntityName, Schema, Statement};
use sea_orm_migration::prelude::*;

struct Migration;

impl MigrationName for Migration {
    fn name(&self) -> &str {
        "m20250507_1423_create_table_reading_history"
    }
}

#[async_trait::async_trait]
impl MigrationTrait for Migration {
    async fn up(
        &self,
        manager: &SchemaManager,
    ) -> std::result::Result<(), sea_orm_migration::DbErr> {
        let db = manager.get_connection();
        let backend = db.get_database_backend();
        let schema = Schema::new(backend);
        manager
            .create_table(
                schema
                    .create_table_from_entity(reading_history::Entity)
                    .if_not_exists()
                    .to_owned(),
            )
            .await?;
        Ok(())
    }

    async fn down(
        &self,
        manager: &SchemaManager,
    ) -> std::result::Result<(), sea_orm_migration::DbErr> {
        Ok(())
    }
}

pub struct Migrator;

#[async_trait::async_trait]
impl MigratorTrait for Migrator {
    fn migrations() -> Vec<Box<dyn MigrationTrait>> {
        vec![Box::new(Migration)]
    }
}
