use sea_orm::{ConnectionTrait, EntityName, Statement};
use sea_orm_migration::prelude::*;
use super::super::reading_history;

struct Migration;

impl MigrationName for Migration {
    fn name(&self) -> &str {
        "m20250507_1425_idx_reading_histories_novel_id"
    }
}

#[async_trait::async_trait]
impl MigrationTrait for Migration {
    async fn up(
        &self,
        manager: &SchemaManager,
    ) -> std::result::Result<(), sea_orm_migration::DbErr> {
        manager
            .create_index(
                Index::create()
                    .if_not_exists()
                    .name("idx_reading_histories_novel_id")
                    .table(reading_history::Entity.table_ref())
                    .col(reading_history::Column::NovelId)
                    .to_owned(),
            )
            .await?;
        Ok(())
    }

    async fn down(
        &self,
        manager: &SchemaManager,
    ) -> std::result::Result<(), sea_orm_migration::DbErr> {
        Ok(())
    }
}

pub struct Migrator;

#[async_trait::async_trait]
impl MigratorTrait for Migrator {
    fn migrations() -> Vec<Box<dyn MigrationTrait>> {
        vec![
            Box::new(Migration),
        ]
    }
}
