use anyhow::Result;
use sea_orm::entity::prelude::*;
use sea_orm::FromQueryResult;
use sea_orm::{Order, QueryFilter, QueryOrder, Statement,};
use sea_orm::{DatabaseBackend, TransactionTrait};
use serde::{Deserialize, Serialize};

#[derive(Clone, Debug, PartialEq, Eq, DeriveEntityModel, Serialize, Deserialize)]
#[sea_orm(table_name = "reading_histories")]
pub struct Model {
    #[sea_orm(primary_key)]
    pub id: i32,
    #[sea_orm(indexed)]
    pub novel_id: String,
    pub novel_name: String,
    pub chapter_id: String,
    pub chapter_title: String,
    pub last_read_at: i64,
    pub progress: i32, // 阅读进度 0-1
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {}

impl ActiveModelBehavior for ActiveModel {}
