use std::{time::Duration};

use sea_orm::prelude::*;
use sea_orm_migration::prelude::*;
use anyhow::{Ok, Result};
mod active;

#[tokio::main]
async fn main() -> Result<()> {
    let conn = connect_db("target/active.db").await?;
    active::migrations::m20250507_1423_create_table_reading_history::Migrator::up(&conn, None).await?;
    active::migrations::m20250507_1425_idx_reading_histories_novel_id::Migrator::up(&conn, None).await?;
    Ok(())
}

pub(crate) async fn connect_db(path: &str) -> Result<DatabaseConnection> {
    let url = format!("sqlite:{}?mode=rwc", path);
    println!("sqlite : {}", url);
    let mut opt = sea_orm::ConnectOptions::new(url);
    opt.max_connections(20)
        .min_connections(5)
        .connect_timeout(Duration::from_secs(8))
        .idle_timeout(Duration::from_secs(8))
        .sqlx_logging(true);
    Ok(sea_orm::Database::connect(opt).await?)
}
