@tool
extends EditorPlugin

var dock
var info_label
var gme
var from_idx

func _get_plugin_name() -> String:
	return "GridMapReplacerPlugin"
	
func do_something():
	print("Doing something")

func pick():
	var gmap = gme.get_current_grid_map()
	if gmap == null:
		return
	from_idx = gme.get_selected_palette_item()
	if from_idx == -1:
		info_label.text = "Select an item to replace!"
	else:
		info_label.text = "Select an item to replace " + str(from_idx) +" with"

func replace():
	var gmap = gme.get_current_grid_map()
	if gmap == null:
		return
	if from_idx == -1:
		info_label.text = "Select an item to replace!"
		return
	var to_idx = gme.get_selected_palette_item()
	var cnt = 0
	for cell in gme.get_selected_cells():
		print(gmap.get_cell_item(cell))
		if gmap.get_cell_item(cell) == from_idx:
			cnt = cnt + 1
			gmap.set_cell_item(cell, to_idx)
	info_label.text = "Replaced " + str(cnt) + " items"

func _enter_tree() -> void:
	gme = EditorInterface.get_editor_plugin("GridMap")
	dock = VBoxContainer.new()
	var btn = Button.new()
	btn.text = "Pick original tile"
	btn.connect("pressed", pick)
	dock.add_child(btn)
	info_label = Label.new()
	info_label.text = "No original tile selected"
	dock.add_child(info_label)
	btn = Button.new()
	btn.text = "Replace in selection"
	btn.connect("pressed", replace)
	dock.add_child(btn)
	dock.name = "Replace Tile"
	add_control_to_dock(EditorPlugin.DOCK_SLOT_LEFT_BR, dock)

func _exit_tree() -> void:
	remove_control_from_docks(dock)
	dock.queue_free()
