using Com.Example;

namespace formatted_semantics;

[Activity(Label = "@string/app_name", MainLauncher = true)]
public class MainActivity : Activity
{
    protected override void OnCreate(Bundle? savedInstanceState)
    {
        base.OnCreate(savedInstanceState);

        // Set our view from the "main" layout resource
        SetContentView(Resource.Layout.activity_main);

        var c = new MyType {
            Text = "Default Value",
        };
        var s = MyType.GetText(c);
        Console.WriteLine ($"           c.Text={c.Text}");
        Console.WriteLine ($"MyType.GetText(c)={s}");
    }
}

    class MyType : ContainsTextFormattedProperty {
        string? text;
    
        public override Java.Lang.ICharSequence? TextFormatted {
            get => new Java.Lang.String ("From C#! " + text);
            set => text = value?.ToString ();
        }
    }
