const mem = @import("std").mem;
//extern var __bss_start: u8;
//extern var __bss_end: u8;

extern fn GET32(val: u32) u32;
extern fn PUT32(addr: u32, val: u32) void;
extern fn nop() void;
// GPIO stuff

// see broadcomm documents for magic addresses.
//const GPIO_BASE = @intToPtr(*volatile u32, 0x20200000);

//const gpio_set0 = @intToPtr(*volatile u32, GPIO_BASE + 0x1C);
//const gpio_clr0 = @intToPtr(*volatile u32, GPIO_BASE + 0x28);
//const gpio_lev0 = @intToPtr(*volatile u32, GPIO_BASE + 0x34);
//const gppud = @intToPtr(*volatile u32, GPIO_BASE + 0x94);
//const gppud_clk0 = @intToPtr(*volatile u32, GPIO_BASE + 0x98);
//const gppud_clk1 = @intToPtr(*volatile u32, GPIO_BASE + 0x9c);

// see broadcomm documents for magic addresses.
const GPIO_BASE = @intToPtr(*volatile u32, 0x20200000);
const GPIO_BASE_INT = @ptrToInt(GPIO_BASE);
const gpio_set0 = @intToPtr(*volatile u32, GPIO_BASE_INT + 0x1C);
const gpio_clr0 = @intToPtr(*volatile u32, GPIO_BASE_INT + 0x28);
const gpio_lev0 = @intToPtr(*volatile u32, GPIO_BASE_INT + 0x34);
const gppud = @intToPtr(*volatile u32, GPIO_BASE_INT + 0x94);
const gppud_clk0 = @intToPtr(*volatile u32, GPIO_BASE_INT + 0x98);
const gppud_clk1 = @intToPtr(*volatile u32, GPIO_BASE_INT + 0x9c);

const GpioFunc = enum(u32) {
    GPIO_FUNC_INPUT = 0,
    GPIO_FUNC_OUTPUT = 1,
    GPIO_FUNC_ALT0 = 4,
    GPIO_FUNC_ALT1 = 5,
    GPIO_FUNC_ALT2 = 6,
    GPIO_FUNC_ALT3 = 7,
    GPIO_FUNC_ALT4 = 3,
    GPIO_FUNC_ALT5 = 2,
};

const GpioError = error{
    InvalidPin,
    InvalidFunction,
};

// set GPIO <pin> on.
fn gpio_set_on(comptime pin: u32) GpioError!void {
    if (pin >= 32 or pin == 47) {
        return GpioError.InvalidPin;
    }
    //set bit 'pin' to 1 within gpio_set0
    //
    //PUT32(gpio_set0, @as(u32, 1) << pin);
    gpio_set0.* = 1 << pin;
}

fn gpio_set_off(comptime pin: u32) GpioError!void {
    if (pin >= 32 or pin == 47) {
        return GpioError.InvalidPin;
    }
    //PUT32(gpio_clr0, 1 << pin);
    gpio_clr0.* = 1 << pin;
}

const GpioState = enum(u8) {
    off = 0,
    on = 1,
};

// set <pin> to be an output pin.
//
// note: fsel0, fsel1, fsel2 are contiguous in memory, so you
// can (and should) use array calculations!
fn gpio_set_function(comptime pin: u32, function: GpioFunc) GpioError!void {
    if (pin >= 32 or pin == 47) {
        return GpioError.InvalidPin;
    }
    if (@enumToInt(function) > 7 or @enumToInt(function) < 0) {
        return GpioError.InvalidFunction;
    }
    // find which GPFSELn word to write to for pin n
    // each  word controls 10 pins
    // so GPFSEL0 controls pins 0-9, etc
    //
    const GPFSELN: u32 = pin / 10;
    const addr = @intToPtr(*volatile u32, @ptrToInt(GPIO_BASE) + (4 * GPFSELN));
    // call GET32 to avoid the C compiler optimizing out our loads and stores
    // to device memory
    //
    var addr_val: u32 = addr.*;
    // set proper bit to be output
    // done by setting a sepcific bit within the addr word to 1
    const FSELN: u32 = pin % 10;
    // want the pins 3 bits to be 001
    // since we may be setting a pin in the middle of
    // our word, we should shift by multiples of 3
    // depending on where our pin lives in the word
    addr_val &= ~(@as(u32, 0b111) << (3 * FSELN)); //clear bits we want to set
    addr_val |= (@enumToInt(function) << (3 * FSELN));
    //PUT32(addr, addr_val);
    addr.* = addr_val;
}

fn gpio_set_output(comptime pin: u32) GpioError!void {
    try gpio_set_function(pin, GpioFunc.GPIO_FUNC_OUTPUT);
}

// set <pin> to input.
fn gpio_set_input(comptime pin: u32) GpioError!void {
    try gpio_set_function(pin, GpioFunc.GPIO_FUNC_INPUT);
}

fn gpio_read(comptime pin: u32) !u32 {
    if (pin >= 32 or pin == 47) {
        return GpioError.InvalidPin;
    }

    var val = GET32(gpio_lev0);
    val >>= pin;
    val &= 1;
    return val;
}

// set <pin> to <v> (v \in {0,1})
fn gpio_write(comptime pin: u32, state: bool) !void {
    if (state == GpioState.on) {
        try gpio_set_on(pin);
    } else {
        try gpio_set_off(pin);
    }
    unreachable;
}

// countdown 'ticks' cycles
fn delay(ticks: u32) void {
    var cnt = @as(u32, ticks);
    while (cnt > 0) {
        nop();
        cnt -= @as(u32, 1);
    }
}


export fn zigMain() noreturn {
    //zero BSS
        //@memset(@as(*volatile [1]u8, &__bss_start), 0, @ptrToInt(&__bss_end) - @ptrToInt(&__bss_start));
        //mem.set(u8, @intToPtr([]u8, __bss_start), 0);
        const led_pin = 20;
        gpio_set_output(led_pin) catch unreachable;

        while (true) {
            
            gpio_set_on(led_pin) catch unreachable;
            delay(1000000);
            gpio_set_off(led_pin) catch unreachable;
            delay(1000000);
        }

    unreachable;
}
